/*
 * Decompiled with CFR 0.152.
 */
package br.com.wesa.crud.usuario;

import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.model.IUser;
import br.com.wesa.crud.usuario.UsuarioMultiTenantBaseEntity;
import br.com.wesa.crud.usuario.UsuarioMultiTenantBaseRepository;
import java.util.Collection;

public abstract class UsuarioMultiTenantBaseService<E extends UsuarioMultiTenantBaseEntity, D extends UsuarioMultiTenantBaseRepository<E>>
extends CrudService<E, D> {
    public E buscaUmPorLogin(String login) {
        return ((UsuarioMultiTenantBaseRepository)this.getRepository()).pesquisaLogin(login);
    }

    public E buscaUmPorToken(String token) {
        return (E)((UsuarioMultiTenantBaseEntity)((UsuarioMultiTenantBaseRepository)this.getRepository()).searchOneBy("token", token));
    }

    public Collection<E> listaTodosUsuarios() {
        return ((UsuarioMultiTenantBaseRepository)this.getRepository()).searchAll();
    }

    public IUser efetuaLogin(String login, String senha) {
        if (login == null || login.isEmpty()) {
            throw new ValidationException("Login obrigat\u00f3rio");
        }
        if (senha == null || senha.isEmpty()) {
            throw new ValidationException("Senha obrigat\u00f3rio");
        }
        E usuario = this.buscaUmPorLogin(login);
        if (!((UsuarioMultiTenantBaseEntity)usuario).senhaValida(senha)) {
            throw new ValidationException("Senha inv\u00e1lida !");
        }
        return usuario;
    }

    public void validaLoginWebService(String login, String senha) {
        if (((UsuarioMultiTenantBaseRepository)this.getRepository()).searchAllBy("login", login).isEmpty()) {
            throw new ValidationException("Login n\u00e3o cadastrado");
        }
        E usuario = this.buscaUmPorLogin(login);
        if (usuario.getSenha() == null) {
            throw new ValidationException("Primeiro Acesso");
        }
        if (!usuario.senhaValida(senha)) {
            throw new ValidationException("Senha inv\u00e1lida");
        }
    }

    public E validaToken(String token) {
        if (((UsuarioMultiTenantBaseRepository)this.getRepository()).searchAllBy("token", token).isEmpty()) {
            throw new ValidationException("Token N\u00c3O localizado");
        }
        return this.buscaUmPorToken(token);
    }

    public void atualizaSenha(String login, String novaSenha) {
        ((UsuarioMultiTenantBaseRepository)this.getRepository()).atualizaSenha(login, novaSenha);
    }

    public void incluiSeNaoExistir(String login) {
        ((UsuarioMultiTenantBaseRepository)this.getRepository()).incluiSeNaoExistir(login);
    }

    public void atualizaUltimoAcesso(E usuario) {
        ((UsuarioMultiTenantBaseRepository)this.getRepository()).atualizaUltimoAcesso(((UsuarioMultiTenantBaseEntity)usuario).getId());
    }
}

