/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util.br;

import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.JsonUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import br.com.jarch.util.br.CepBean;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;

@Dependent
public class CepService
implements Serializable {
    private static final String CEP = "cep";
    private static final String V1 = "v1";
    private static final String SERVICE_REST = "https://api.postmon.com.br";

    public static CepService getInstance() {
        return (CepService)CDI.current().select(CepService.class, new Annotation[0]).get();
    }

    public CepBean buscaCep(String cep) {
        if (StringUtils.isNullOrEmpty(cep)) {
            return new CepBean();
        }
        String numeroCep = CharacterUtils.onlyNumber(cep);
        Response response = ClientBuilder.newClient().target(SERVICE_REST).path(V1).path(CEP).path(numeroCep).request(new String[]{"application/json"}).accept(new String[]{"application/json"}).get();
        if (response.getStatus() != 200) {
            LogUtils.generate("ERRO NA CONSULTA DO CEP: " + numeroCep + " - " + response.getStatus() + " - " + (String)response.readEntity(String.class));
            return new CepBean();
        }
        String cepResult = (String)response.readEntity(String.class);
        return JsonUtils.toObject(CepBean.class, cepResult);
    }
}

