/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static String toJson(Object object) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T toObject(Class<T> clazz, String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> Collection<T> toCollection(Class<T> clazz, String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(Collection.class, clazz);
            return (Collection)objectMapper.readValue(json, (JavaType)collectionType);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonObject toJsonObject(String json) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    public static boolean isValidJson(String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return false;
        }
        try {
            JsonUtils.toJsonObject(jsonString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

