/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.gca.fx.util;

import br.com.jarch.gca.fx.main.Aplicacao;
import br.com.jarch.gca.fx.util.ImagemFx;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public abstract class BaseFxml
implements Initializable {
    private static final Map<String, Stage> mapaStage = new HashMap<String, Stage>();
    private static final Map<String, String> mapaChamador = new HashMap<String, String>();
    private Stage stage;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;

    public Stage getStage() {
        return this.stage;
    }

    public void processarTeclasAtalho(KeyEvent event) {
        if (event.isControlDown() && event.getCode() == KeyCode.MULTIPLY) {
            this.stage.setOpacity(this.stage.getOpacity() + 0.01);
        } else if (event.isControlDown() && event.getCode() == KeyCode.DIVIDE) {
            this.stage.setOpacity(this.stage.getOpacity() - 0.01);
        }
    }

    public void mostraTela(Class<? extends BaseFxml> classeChamador) {
        if (classeChamador != null) {
            mapaChamador.put(this.getClass().getSimpleName(), classeChamador.getSimpleName());
            this.stage = mapaStage.get(classeChamador.getSimpleName());
            if (this.stage != null) {
                this.stage.close();
            }
        }
        String nomeStage = this.getClass().getSimpleName();
        this.stage = mapaStage.get(nomeStage);
        this.configuraStage();
        mapaStage.put(nomeStage, this.stage);
        try {
            String arquivoFxml = "/fxml/" + this.getClass().getSimpleName().replace(".", "/") + ".fxml";
            String language = System.getProperty("user.language");
            String country = System.getProperty("user.country");
            ResourceBundle bundle = ResourceBundle.getBundle("bundle.bundle", new Locale(language, country));
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(arquivoFxml), bundle);
            Parent root = (Parent)fxmlLoader.load();
            Initializable initializable = (Initializable)fxmlLoader.getController();
            root.setOnKeyReleased(keyEvent -> ((BaseFxml)initializable).processarTeclasAtalho((KeyEvent)keyEvent));
            root.setOnMousePressed(event -> {
                this.mouseDragOffsetX = event.getSceneX();
                this.mouseDragOffsetY = event.getSceneY();
            });
            root.setOnMouseDragged(event -> {
                if (!event.isControlDown()) {
                    return;
                }
                this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
                this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
            });
            this.stage.setScene(new Scene(root));
            this.stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void configuraStage() {
        this.stage = new Stage(StageStyle.TRANSPARENT);
        this.stage.getIcons().add(ImagemFx.getInstancia().getImgIcone());
        this.stage.setTitle("GCA - JARCH Framework");
        this.stage.sizeToScene();
    }

    protected void sairMinimizar(Class<? extends BaseFxml> classe, MouseEvent mouseEvent) {
        Stage stageAtual = mapaStage.get(classe.getSimpleName());
        if (mouseEvent.getX() < 35.0) {
            stageAtual.setIconified(true);
        } else {
            stageAtual.close();
        }
        String nomeStageChamador = classe.getSimpleName();
        String nomeStageDestino = mapaChamador.get(nomeStageChamador);
        Stage stageDestino = mapaStage.get(nomeStageDestino);
        if (stageDestino != null) {
            if (stageDestino.getOnShown() != null) {
                stageDestino.getOnShown().handle(null);
            }
            stageDestino.show();
        }
    }

    protected void fecharMinimizar(MouseEvent mouseEvent) {
        if (mouseEvent.getX() < 35.0) {
            Stage stageAtual = (Stage)((Node)mouseEvent.getSource()).getScene().getWindow();
            stageAtual.setIconified(true);
        } else {
            Aplicacao.getInstancia().encerrar();
        }
    }
}

