/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessagePropertiesUtils {
    private MessagePropertiesUtils() {
    }

    public static String messageBundle(String baseName, String key) {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = MessagePropertiesUtils.getBundle(baseName);
            if (resourceBundle.keySet().stream().anyMatch(k -> k.equals(key))) {
                return resourceBundle.getString(key);
            }
        }
        catch (Exception ex) {
            LogUtils.generateSilent(ex);
        }
        try {
            resourceBundle = MessagePropertiesUtils.getBundle(baseName + "Company");
            if (resourceBundle.keySet().stream().anyMatch(k -> k.equals(key))) {
                return resourceBundle.getString(key);
            }
        }
        catch (Exception ex) {
            LogUtils.generateSilent(ex);
        }
        try {
            resourceBundle = MessagePropertiesUtils.getBundle(baseName + "JArch");
            if (resourceBundle.keySet().stream().anyMatch(k -> k.equals(key))) {
                return resourceBundle.getString(key);
            }
        }
        catch (Exception ex) {
            LogUtils.generateSilent(ex);
        }
        if (key.startsWith("{") && key.endsWith("}")) {
            String newKey = key.substring(1, key.length() - 1);
            return MessagePropertiesUtils.messageBundle(baseName, newKey);
        }
        return "???" + key + "???";
    }

    public static String messageBundleParam(String baseName, String key, String ... parameters) {
        try {
            Object[] params = MessagePropertiesUtils.messageBundleParameters(baseName, parameters);
            String value = String.format(MessagePropertiesUtils.messageBundle(baseName, key), params);
            if (Arrays.stream(parameters).allMatch(p -> value.contains((CharSequence)p))) {
                return value;
            }
            return MessageFormat.format(value, params);
        }
        catch (MissingResourceException ex) {
            LogUtils.generateSilent(ex);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        return "???" + key + "???";
    }

    private static ResourceBundle getBundle(String baseName) {
        Locale locale = Locale.getDefault();
        try {
            locale = GlobalInformation.getInstance().getLocale();
        }
        catch (Exception ex) {
            LogUtils.generateSilent(ex);
        }
        try {
            if (MultiTenant.getInstance().exists() && StringUtils.isNullOrEmpty(locale.getVariant())) {
                locale = new Locale("pt", "BR", "" + MultiTenant.getInstance().get());
                GlobalInformation.getInstance().setLocale(locale);
            }
        }
        catch (Exception ex) {
            LogUtils.generateSilent(ex);
        }
        try {
            return ResourceBundle.getBundle(baseName, locale);
        }
        catch (Exception ex) {
            LogUtils.generateSilent(ex);
            try {
                try {
                    if (MultiTenant.getInstance().exists() && !locale.getVariant().equals("" + MultiTenant.getInstance().get())) {
                        locale = new Locale(locale.getLanguage(), locale.getCountry(), "" + MultiTenant.getInstance().get());
                        GlobalInformation.getInstance().setLocale(locale);
                    }
                }
                catch (Exception ex2) {
                    LogUtils.generateSilent(ex2);
                }
                return ResourceBundle.getBundle(baseName, locale);
            }
            catch (Exception ex3) {
                LogUtils.generateSilent(ex3);
                locale = new Locale("pt", "BR");
                try {
                    return ResourceBundle.getBundle(baseName, locale);
                }
                catch (Exception ex4) {
                    LogUtils.generateSilent(ex4);
                    try {
                        return ResourceBundle.getBundle("bundle.bundle");
                    }
                    catch (Exception ex5) {
                        LogUtils.generateSilent(ex5);
                        return ResourceBundle.getBundle(baseName);
                    }
                }
            }
        }
    }

    private static String[] messageBundleParameters(String baseName, String[] parametros) {
        if (parametros == null || parametros.length < 1) {
            return parametros;
        }
        for (int i = 0; i < parametros.length; ++i) {
            if (parametros[i] != null) {
                String parametro = parametros[i];
                parametros[i] = parametro.startsWith("#") ? parametro.substring(1) : MessagePropertiesUtils.messageBundle(baseName, parametro);
                if (parametros[i].startsWith("???")) {
                    parametros[i] = parametros[i].replace("???", "");
                    parametros[i] = BundleUtils.messageBundle(parametros[i]);
                }
            }
            if (!parametros[i].startsWith("???") || parametros[i].contains("label.") || parametros[i].contains("message.")) continue;
            parametros[i] = parametros[i].replace("???", "");
        }
        return parametros;
    }
}

