/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.exception.HashTagException;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.util.BundleUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class HashTagUtils {
    private static final String REGEX_HASHTAG = "[#]+[{][a-z,_]+[}]";

    private HashTagUtils() {
    }

    public static String replaceHashTag(String conteudo, Map<String, String> hashTags) {
        return HashTagUtils.replaceHashTag(REGEX_HASHTAG, conteudo, hashTags);
    }

    public static String replaceHashTag(String expressaoRegular, String conteudo, Map<String, String> hashTags) {
        String retorno = conteudo;
        Pattern pattern = Pattern.compile(expressaoRegular, 2);
        Matcher matcher = pattern.matcher(retorno);
        while (matcher.find()) {
            String hashTag;
            String chave = (hashTag = matcher.group(0)).replace("#{", "").replace("}", "");
            String conteudoHashTag = hashTags.get(chave);
            retorno = retorno.replace(hashTag, conteudoHashTag == null ? "" : conteudoHashTag);
        }
        retorno = HashTagUtils.substituirHashTagCadastradoServidorAplicacao(expressaoRegular, retorno);
        retorno = HashTagUtils.substituirHashTagCadastradoVariavelAmbiente(expressaoRegular, retorno);
        matcher = pattern.matcher(retorno = HashTagUtils.substituirHashTagParametroJvm(expressaoRegular, retorno));
        if (matcher.find()) {
            throw new HashTagException("CONTEUDO DE HASHTAG NAO ENCONTRADO " + matcher.group(0));
        }
        return retorno;
    }

    private static String substituirHashTagCadastradoServidorAplicacao(String expressaoRegular, String conteudo) {
        String valueReturn = conteudo;
        Pattern pattern = Pattern.compile(expressaoRegular, 2);
        Matcher matcher = pattern.matcher(valueReturn);
        while (matcher.find()) {
            String hashTag = matcher.group(0);
            String chave = hashTag.replace("#{", "").replace("}", "");
            String conteudoServidor = System.getProperty(chave);
            if (conteudoServidor == null) continue;
            valueReturn = valueReturn.replace(hashTag, conteudoServidor);
        }
        return valueReturn;
    }

    private static String substituirHashTagCadastradoVariavelAmbiente(String expressaoRegular, String conteudo) {
        String valueReturn = conteudo;
        Pattern pattern = Pattern.compile(expressaoRegular, 2);
        Matcher matcher = pattern.matcher(valueReturn);
        while (matcher.find()) {
            String hashTag = matcher.group(0);
            String chave = hashTag.replace("#{", "").replace("}", "");
            String conteudoServidor = System.getenv(chave.toUpperCase(Locale.forLanguageTag("pt-BR")));
            if (conteudoServidor == null) continue;
            valueReturn = valueReturn.replace(hashTag, conteudoServidor);
        }
        return valueReturn;
    }

    private static String substituirHashTagParametroJvm(String expressaoRegular, String conteudo) {
        String valueReturn = conteudo;
        Pattern pattern = Pattern.compile(expressaoRegular, 2);
        Matcher matcher = pattern.matcher(valueReturn);
        while (matcher.find()) {
            String hashTag = matcher.group(0);
            String chave = hashTag.replace("#{", "").replace("}", "");
            String conteudoJvm = System.getProperty(chave.toUpperCase(Locale.forLanguageTag("pt-BR")));
            if (conteudoJvm == null) continue;
            valueReturn = valueReturn.replace(hashTag, conteudoJvm);
        }
        return valueReturn;
    }

    public static void validHashTags(List<String> hashTags, String text) {
        Pattern pattern = Pattern.compile("#(?:\\{[^}]+\\}|\\w+)");
        Matcher matcher = pattern.matcher(text);
        List listWithHash = hashTags.stream().map(h -> h.startsWith("#") ? h.substring(1) : h).map(h -> h.startsWith("#{") && h.endsWith("}") ? h.substring(2, h.length() - 1) : h).collect(Collectors.toList());
        while (matcher.find()) {
            String hashTagOrig = matcher.group();
            if (hashTagOrig.equals("#64")) continue;
            String hashTag = hashTagOrig;
            if (hashTag.startsWith("#{") && hashTag.endsWith("}")) {
                hashTag = hashTag.substring(2, hashTag.length() - 1);
            }
            if (hashTag.startsWith("#")) {
                hashTag = hashTag.substring(1);
            }
            String finalHashTag = hashTag;
            if (!listWithHash.stream().noneMatch(h -> h.equals(finalHashTag))) continue;
            throw new ValidationException(BundleUtils.messageBundleParam("message.hashNaoDefinida", "#" + hashTagOrig));
        }
    }
}

