/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.model;

import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.util.NumberUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Named;

@Vetoed
@Named
public class MultiTenant
implements Serializable {
    private long value;

    public static MultiTenant getInstance() {
        return (MultiTenant)CDI.current().select(MultiTenant.class, new Annotation[0]).get();
    }

    public long get() {
        Long id;
        if (this.value < 1L && NumberUtils.isDiffNullAndZero(id = MultiTenant.getIdMultitenantThread())) {
            this.setIfNotExists(id);
        }
        return this.value;
    }

    public void set(long multiTenantId) {
        this.value = multiTenantId;
        MultiTenant.setIdMultitenantThread(multiTenantId);
        GlobalInformation.getInstance().set("jarch.multitenant", this);
        GlobalInformation.getInstance().configLocale(multiTenantId);
    }

    public void setIfNotExists(long multiTenantId) {
        if (this.exists()) {
            return;
        }
        this.set(multiTenantId);
    }

    private static void setIdMultitenantThread(long multiTenantId) {
        String nameThreadOld = Thread.currentThread().getName();
        Object nameThreadNew = Thread.currentThread().getName();
        if (((String)nameThreadNew).contains("_IdMultitenant=")) {
            nameThreadNew = ((String)nameThreadNew).replaceAll("_IdMultitenant=-?\\d+_", "");
        }
        nameThreadNew = (String)nameThreadNew + "_IdMultitenant=" + multiTenantId + "_";
        GlobalInformation.getInstance().moveAllToNewKey(nameThreadOld, (String)nameThreadNew);
        Thread.currentThread().setName((String)nameThreadNew);
    }

    public void remove() {
        this.value = 0L;
    }

    public boolean exists() {
        return !this.notExists();
    }

    public boolean notExists() {
        return this.value == 0L;
    }

    public boolean isSession() {
        return GlobalInformation.getInstance().isSession();
    }

    public static Long getIdMultitenantThread() {
        String nameThread = Thread.currentThread().getName();
        String regex = "IdMultitenant=(\\d+)_";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(nameThread);
        if (!matcher.find()) {
            throw new ValidationException("N\u00e3o localizado o ID do multitenant");
        }
        String idMultitenant = matcher.group(1);
        return Long.parseLong(idMultitenant);
    }
}

