/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.migration;

import br.com.jarch.core.crud.repository.CrudRepository;
import br.com.jarch.core.crud.service.ICrudService;
import br.com.jarch.core.migration.ExclusiveMigrated;
import br.com.jarch.core.migration.ExclusivesMigrated;
import br.com.jarch.core.migration.Migrated;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.CDI;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public final class CloneMigratedEntity {
    private CloneMigratedEntity() {
    }

    public static <E extends ICrudEntity, S extends ICrudService<E>, D extends CrudRepository<E>> E clone(Long idMultiTenant, S facade, D manager, E entity) {
        return CloneMigratedEntity.clone(idMultiTenant, facade, manager, entity, new HashMap<Object, Object>(), true);
    }

    private static <E extends ICrudEntity, S extends ICrudService<E>, D extends CrudRepository<E>> E clone(Long idMultiTenant, S facade, D manager, E entity, Map<Object, Object> entityCache, boolean noCloneId) {
        Object fieldValue;
        Field[] fields;
        ICrudEntity cacheCopy = (ICrudEntity)entityCache.get(entity);
        if (cacheCopy != null) {
            return (E)cacheCopy;
        }
        ICrudEntity entityCopy = (ICrudEntity)ReflectionUtils.createInstance(entity.getClass());
        entityCache.put(entity, entityCopy);
        for (Field entityField : fields = ReflectionUtils.getArrayFields(entity, true, true)) {
            if (Modifier.isFinal(entityField.getModifiers()) || entityField.isAnnotationPresent(Id.class) && noCloneId || !JpaUtils.isObjectInitialize(entity, entityField)) continue;
            try {
                ReflectionUtils.setAttributesAcessible(entityField);
                fieldValue = entityField.get(entity);
                if (CloneMigratedEntity.isEntity(fieldValue)) {
                    Migrated migrated = new Migrated((ICrudEntity)fieldValue);
                    ICrudEntity fieldValueCopy = CloneMigratedEntity.clone(idMultiTenant, migrated.getService(), migrated.getRepository(), (ICrudEntity)fieldValue, entityCache, true);
                    entityCache.put(fieldValue, fieldValueCopy);
                    Field oneToOneBack = CloneMigratedEntity.getCampoRelacionamento(entityCopy, fieldValue, OneToOne.class);
                    if (oneToOneBack != null) {
                        ReflectionUtils.setValue(fieldValueCopy, oneToOneBack, (Object)entityCopy);
                    }
                    fieldValue = fieldValueCopy;
                }
                if (fieldValue instanceof Collection) continue;
                if (entityField.getName().equals("multiTenantId")) {
                    entityField.set(entityCopy, idMultiTenant);
                    continue;
                }
                if (entityField.getName().equals("id")) continue;
                entityField.set(entityCopy, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Migrated migrated = new Migrated(entityCopy);
            ICrudEntity entityValid = ExclusiveMigrated.validationUniqueField(migrated.getRepository(), entityCopy);
            if (entityValid == null) {
                entityValid = ExclusivesMigrated.validationMultipleFields(migrated.getRepository(), entityCopy);
            }
            if (entityValid != null) {
                entityCopy.setId(entityValid.getId());
            } else {
                facade.insert((ICrudEntity)entityCopy);
            }
            EntityManager entityManager = (EntityManager)CDI.current().select(EntityManager.class, new Annotation[0]).get();
            entityManager.find(entityCopy.getClass(), (Object)entityCopy.getId());
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        for (Field entityField : fields) {
            if (Modifier.isFinal(entityField.getModifiers()) || entityField.isAnnotationPresent(Id.class) && noCloneId || !JpaUtils.isObjectInitialize(entity, entityField)) continue;
            try {
                ReflectionUtils.setAttributesAcessible(entityField);
                fieldValue = entityField.get(entity);
                if (CloneMigratedEntity.isEntity(fieldValue)) {
                    ICrudEntity fieldValueCopy = CloneMigratedEntity.clone(idMultiTenant, facade, manager, (ICrudEntity)fieldValue, entityCache, true);
                    entityCache.put(fieldValue, fieldValueCopy);
                    Field oneToOneBack = CloneMigratedEntity.getCampoRelacionamento(entityCopy, fieldValue, OneToOne.class);
                    if (oneToOneBack != null) {
                        ReflectionUtils.setValue(fieldValueCopy, oneToOneBack, (Object)entityCopy);
                    }
                    fieldValue = fieldValueCopy;
                } else if (fieldValue instanceof Collection) {
                    boolean oneToManyRelationship = entityField.isAnnotationPresent(OneToMany.class);
                    fieldValue = CloneMigratedEntity.geraCloneColecao(idMultiTenant, entityCopy, (Collection)fieldValue, oneToManyRelationship, entityCache, true);
                }
                if (entityField.getName().equals("multiTenantId")) {
                    entityField.set(entityCopy, idMultiTenant);
                    continue;
                }
                if (entityField.getName().equals("id")) continue;
                entityField.set(entityCopy, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return (E)entityCopy;
    }

    private static <E extends ICrudEntity, S extends ICrudService<E>, D extends CrudRepository<E>> Collection<E> geraCloneColecao(Long idMultiTenant, Object entityCopy, Collection collection, boolean oneToManyRelationship, Map<Object, Object> entityCache, boolean limpaId) throws IllegalArgumentException, IllegalAccessException {
        Collection collectionCopy = (Collection)ReflectionUtils.createInstance(collection.getClass());
        if (oneToManyRelationship) {
            for (Object item : collection) {
                if (!CloneMigratedEntity.isEntity(item)) continue;
                Migrated migrated = new Migrated((ICrudEntity)item);
                ICrudEntity itemCopy = CloneMigratedEntity.clone(idMultiTenant, migrated.getService(), migrated.getRepository(), (ICrudEntity)item, entityCache, limpaId);
                Field relationshipBackField = CloneMigratedEntity.getCampoRelacionamento(entityCopy, itemCopy, ManyToOne.class);
                if (relationshipBackField == null) {
                    relationshipBackField = CloneMigratedEntity.getCampoRelacionamento(entityCopy, itemCopy, OneToOne.class);
                }
                if (relationshipBackField != null) {
                    ReflectionUtils.setAttributesAcessible(relationshipBackField);
                    relationshipBackField.set(itemCopy, entityCopy);
                }
                collectionCopy.add(itemCopy);
            }
        } else {
            collectionCopy.addAll(collection);
        }
        return collectionCopy;
    }

    private static Field getCampoRelacionamento(Object entityCopy, Object entity, Class<? extends Annotation> relationshipType) {
        Field[] fields;
        for (Field field : fields = ReflectionUtils.getArrayFields(entity, true, true)) {
            if (!field.isAnnotationPresent(relationshipType) || !entityCopy.getClass().equals(field.getType())) continue;
            return field;
        }
        return null;
    }

    private static boolean isEntity(Object bean) {
        return bean != null && (bean.getClass().isAnnotationPresent(Entity.class) || bean.getClass().isAnnotationPresent(Embeddable.class));
    }
}

