/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.param;

import br.com.jarch.core.annotation.JArchExclusionLogic;
import br.com.jarch.core.jpa.api.IAggregateJpql;
import br.com.jarch.core.jpa.param.ParamFieldValue;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.model.IMultiTenantEntity;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.type.ConditionSearchType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.CDI;

public class ParamFieldValues {
    private List<ParamFieldValue> listParamFieldValue;

    public ParamFieldValues(Class<? extends IIdentity> classEntity) {
        this.init(classEntity, true);
    }

    public ParamFieldValues(Class<? extends IIdentity> classEntity, boolean addFilterDefault) {
        this.init(classEntity, addFilterDefault);
    }

    private void init(Class<? extends IIdentity> classEntity, boolean addFilterDefault) {
        this.listParamFieldValue = new ArrayList<ParamFieldValue>();
        if (addFilterDefault) {
            MultiTenant multiTenant = (MultiTenant)CDI.current().select(MultiTenant.class, new Annotation[0]).get();
            if (!multiTenant.isSession() && IMultiTenantEntity.class.isAssignableFrom(classEntity)) {
                this.addFilterMultiTenant();
            }
            if (!multiTenant.isSession() && classEntity.isAnnotationPresent(JArchExclusionLogic.class)) {
                this.addFilterExclusionLogic();
            }
        }
    }

    public void add(ParamFieldValue paramFieldValue) {
        paramFieldValue.setNameParameterJpql(this.listParamFieldValue.size());
        this.listParamFieldValue.add(paramFieldValue);
    }

    public void add(ParamFieldValue.OperatorType operator, String field, ConditionSearchType conditionSearch, Object value, String startOperatorLogic, boolean caseSensitive) {
        ParamFieldValue paramFieldValue = new ParamFieldValue(operator);
        paramFieldValue.setStartOperatorLogic(startOperatorLogic);
        paramFieldValue.setAttribute(field);
        paramFieldValue.setConditionSearch(conditionSearch);
        paramFieldValue.setValue(value);
        paramFieldValue.setCaseSensitive(caseSensitive);
        this.add(paramFieldValue);
    }

    public void add(ParamFieldValue.OperatorType operator, String field, ConditionSearchType conditionSearch, Object value, String startOperatorLogic) {
        ParamFieldValue paramFieldValue = new ParamFieldValue(operator);
        paramFieldValue.setStartOperatorLogic(startOperatorLogic);
        paramFieldValue.setAttribute(field);
        paramFieldValue.setConditionSearch(conditionSearch);
        paramFieldValue.setValue(value);
        this.add(paramFieldValue);
    }

    public void add(ParamFieldValue.OperatorType operator, IAggregateJpql aggregate, ConditionSearchType conditionSearch, Object value, String startOperatorLogic) {
        ParamFieldValue paramFieldValue = new ParamFieldValue(operator);
        paramFieldValue.setStartOperatorLogic(startOperatorLogic);
        paramFieldValue.setPrefixField(false);
        paramFieldValue.setAttribute(aggregate.getCommand());
        paramFieldValue.setConditionSearch(conditionSearch);
        paramFieldValue.setValue(value);
        this.add(paramFieldValue);
    }

    public void addFilterMultiTenant() {
        this.add(ParamFieldValue.OperatorType.AND, "multiTenantId", ConditionSearchType.EQUAL, (Object)((MultiTenant)CDI.current().select(MultiTenant.class, new Annotation[0]).get()).get(), "");
    }

    public void addFilterExclusionLogic() {
        this.add(ParamFieldValue.OperatorType.AND, "dateHourLogicExclusion", ConditionSearchType.EQUAL, null, "");
    }

    public List<ParamFieldValue> get() {
        return Collections.unmodifiableList(this.listParamFieldValue);
    }

    public void setEndOperatorLogicLastParamFieldValue(String operatorLogic) {
        ParamFieldValue paramFieldValue = this.listParamFieldValue.get(this.listParamFieldValue.size() - 1);
        paramFieldValue.setEndOperatorLogic(paramFieldValue.getEndOperatorLogic() + operatorLogic);
    }
}

