/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.util;

import br.com.jarch.core.annotation.JArchNoClone;
import br.com.jarch.core.annotation.JArchNoCloneId;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public final class CloneEntityUtils {
    private CloneEntityUtils() {
    }

    public static <E> E clone(E entity) {
        return CloneEntityUtils.clone(entity, new HashMap<Object, Object>(), true);
    }

    public static <E> E clone(E entity, boolean noCloneId) {
        return CloneEntityUtils.clone(entity, new HashMap<Object, Object>(), noCloneId);
    }

    private static <E> E clone(E entity, Map<Object, Object> entityCache, boolean noCloneId) {
        Field[] fields;
        Object cacheCopy = entityCache.get(entity);
        if (cacheCopy != null) {
            return (E)cacheCopy;
        }
        Object entityCopy = ReflectionUtils.createInstance(entity.getClass());
        entityCache.put(entity, entityCopy);
        for (Field entityField : fields = ReflectionUtils.getArrayFields(entity, true, true)) {
            if (Modifier.isFinal(entityField.getModifiers()) || entityField.isAnnotationPresent(JArchNoClone.class) || entityField.isAnnotationPresent(Id.class) && noCloneId || !JpaUtils.isObjectInitialize(entity, entityField)) continue;
            try {
                ReflectionUtils.setAttributesAcessible(entityField);
                HashMap fieldValue = entityField.get(entity);
                if (!entityField.isAnnotationPresent(ManyToOne.class) && CloneEntityUtils.isEntity(fieldValue)) {
                    Object fieldValueCopy = CloneEntityUtils.clone(fieldValue, entityCache, entityField.isAnnotationPresent(JArchNoCloneId.class));
                    entityCache.put(fieldValue, fieldValueCopy);
                    Field oneToOneBack = CloneEntityUtils.getCampoRelacionamento(entityCopy, fieldValue, OneToOne.class);
                    if (oneToOneBack != null) {
                        ReflectionUtils.setValue(fieldValueCopy, oneToOneBack, entityCopy);
                    }
                    fieldValue = fieldValueCopy;
                } else if (fieldValue instanceof Collection) {
                    boolean oneToManyRelationship = entityField.isAnnotationPresent(OneToMany.class);
                    fieldValue = CloneEntityUtils.geraCloneColecao(entityCopy, (Collection)((Object)fieldValue), oneToManyRelationship, entityCache, entityField.isAnnotationPresent(JArchNoCloneId.class));
                } else if (fieldValue instanceof Map && entityField.isAnnotationPresent(MapKeyColumn.class)) {
                    boolean dynamicColumn = entityField.getAnnotation(MapKeyColumn.class).name().equals("nm_column");
                    fieldValue = dynamicColumn ? new HashMap() : new HashMap(fieldValue);
                } else if (fieldValue instanceof Map) {
                    fieldValue = new HashMap(fieldValue);
                }
                entityField.set(entityCopy, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return (E)entityCopy;
    }

    private static <E extends IIdentity> Collection<E> geraCloneColecao(Object entityCopy, Collection collection, boolean oneToManyRelationship, Map<Object, Object> entityCache, boolean limpaId) throws IllegalArgumentException, IllegalAccessException {
        Collection collectionCopy = (Collection)ReflectionUtils.createInstance(collection.getClass());
        if (oneToManyRelationship) {
            for (Object item : collection) {
                if (!CloneEntityUtils.isEntity(item)) continue;
                IIdentity itemCopy = CloneEntityUtils.clone((IIdentity)item, entityCache, limpaId);
                Field relationshipBackField = CloneEntityUtils.getCampoRelacionamento(entityCopy, itemCopy, ManyToOne.class);
                if (relationshipBackField == null) {
                    relationshipBackField = CloneEntityUtils.getCampoRelacionamento(entityCopy, itemCopy, OneToOne.class);
                }
                if (relationshipBackField != null) {
                    ReflectionUtils.setAttributesAcessible(relationshipBackField);
                    relationshipBackField.set(itemCopy, entityCopy);
                }
                collectionCopy.add(itemCopy);
            }
        } else {
            collectionCopy.addAll(collection);
        }
        return collectionCopy;
    }

    private static Field getCampoRelacionamento(Object entityCopy, Object entity, Class<? extends Annotation> relationshipType) {
        Field[] fields;
        for (Field field : fields = ReflectionUtils.getArrayFields(entity, true, true)) {
            if (!field.isAnnotationPresent(relationshipType) || !entityCopy.getClass().equals(field.getType())) continue;
            return field;
        }
        return null;
    }

    private static boolean isEntity(Object bean) {
        return bean != null && (bean.getClass().isAnnotationPresent(Entity.class) || bean.getClass().isAnnotationPresent(Embeddable.class));
    }
}

