/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.util;

import br.com.jarch.core.annotation.JArchAutoIncrement;
import br.com.jarch.core.crud.sequence.BaseSequenceEntity;
import br.com.jarch.core.crud.util.AutoIncrementInternal;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.JpqlUtils;
import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.CDI;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;

public final class AutoIncrementUtils {
    private static final String FIELD_IS_NOT_NULL = " IS NOT NULL ";
    private static final String AND_CONDITION = "AND x.";
    private static final String PARAMETER_PREFIX = " = :";

    private AutoIncrementUtils() {
    }

    public static void generateInsert(ICrudEntity entity) {
        AutoIncrementUtils.processAutoIncrement(entity, true, false);
    }

    public static void generateChange(ICrudEntity entity) {
        AutoIncrementUtils.processAutoIncrement(entity, false, true);
    }

    private static void processAutoIncrement(ICrudEntity entity, boolean inserted, boolean changed) {
        if (BaseSequenceEntity.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        ReflectionUtils.getListFields(entity, true, true).forEach(field -> AutoIncrementUtils.processFieldAutoIncrement(entity, field, inserted, changed));
    }

    private static <E extends ICrudEntity> void processFieldAutoIncrement(E entity, Field field, boolean inserted, boolean changed) {
        List<AutoIncrementInternal> incrementConfigs = AutoIncrementUtils.getAutoIncrementConfigs(field, inserted, changed);
        incrementConfigs.stream().sorted(Comparator.comparing(AutoIncrementInternal::getPriority)).forEach(config -> AutoIncrementUtils.updateFieldValue(entity, field, config));
    }

    private static List<AutoIncrementInternal> getAutoIncrementConfigs(Field field, boolean inserted, boolean changed) {
        return Arrays.stream((JArchAutoIncrement[])field.getAnnotationsByType(JArchAutoIncrement.class)).filter(annotation -> AutoIncrementUtils.isApplicableAnnotation(annotation, inserted, changed)).map(AutoIncrementUtils::createAutoIncrementInternal).collect(Collectors.toList());
    }

    private static boolean isApplicableAnnotation(JArchAutoIncrement annotation, boolean inserted, boolean changed) {
        return !(inserted && !annotation.inserted() || changed && !annotation.changed());
    }

    private static AutoIncrementInternal createAutoIncrementInternal(JArchAutoIncrement annotation) {
        AutoIncrementInternal config = new AutoIncrementInternal();
        config.setCondition(annotation.condition());
        config.setPriority(annotation.priority());
        config.setFieldGroups(annotation.fieldGroups());
        config.setSize(annotation.size());
        config.setStart(annotation.start());
        return config;
    }

    private static <E extends ICrudEntity> void updateFieldValue(E entity, Field field, AutoIncrementInternal config) {
        try {
            if (AutoIncrementUtils.notFoundCondition(entity, config)) {
                return;
            }
            Object currentValue = ReflectionUtils.getValueByField(entity, field);
            if (currentValue != null && !currentValue.toString().isBlank()) {
                return;
            }
            Number nextValue = AutoIncrementUtils.calculateNextValue(entity, field, config);
            AutoIncrementUtils.setFieldValue(entity, field, nextValue, config.getSize().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).size());
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    private static <E extends ICrudEntity> boolean foundCondition(E entity, AutoIncrementInternal config) throws Exception {
        Predicate<? extends ICrudEntity> condition = config.getCondition().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return condition.test(entity);
    }

    private static <E extends ICrudEntity> boolean notFoundCondition(E entity, AutoIncrementInternal config) throws Exception {
        return !AutoIncrementUtils.foundCondition(entity, config);
    }

    private static <E extends ICrudEntity> Number calculateNextValue(E entity, Field field, AutoIncrementInternal config) throws Exception {
        EntityManager entityManager = (EntityManager)CDI.current().select(EntityManager.class, new Annotation[0]).get();
        TypedQuery<ICrudEntity> query = AutoIncrementUtils.createQuery(entity, field, config, entityManager);
        Number currentMax = AutoIncrementUtils.getCurrentMaxValue(query, field);
        long nextValue = currentMax.longValue() + 1L;
        long startValue = config.getStart().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).start();
        return Math.max(nextValue, startValue);
    }

    private static <E extends ICrudEntity> TypedQuery<ICrudEntity> createQuery(E entity, Field field, AutoIncrementInternal config, EntityManager entityManager) {
        String jpql = AutoIncrementUtils.buildJpqlQuery(entity, field, config);
        TypedQuery query = entityManager.createQuery(jpql, ICrudEntity.class);
        for (String groupField : config.getFieldGroups()) {
            query.setParameter(groupField, ReflectionUtils.getValueByName(entity, groupField));
        }
        return query.setMaxResults(1).setLockMode(LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    private static <E extends ICrudEntity> String buildJpqlQuery(E entity, Field field, AutoIncrementInternal config) {
        StringBuilder jpql = new StringBuilder().append("SELECT x FROM ").append(JpqlUtils.aliasEntity(entity.getClass())).append(" x WHERE ").append(field.getName()).append(FIELD_IS_NOT_NULL);
        for (String groupField : config.getFieldGroups()) {
            jpql.append(AND_CONDITION).append(groupField).append(PARAMETER_PREFIX).append(groupField).append(" ");
        }
        return jpql.append("ORDER BY x.").append(field.getName()).append(" DESC").toString();
    }

    private static Number getCurrentMaxValue(TypedQuery<ICrudEntity> query, Field field) {
        List results = query.getResultList();
        Object maxValue = results.isEmpty() ? null : ReflectionUtils.getValueByField(results.get(0), field);
        return new BigInteger(maxValue == null ? "0" : maxValue.toString());
    }

    private static void setFieldValue(ICrudEntity entity, Field field, Number value, int size) {
        Class<?> fieldType = field.getType();
        Object convertedValue = size > 0 && String.class.isAssignableFrom(fieldType) ? NumberUtils.formatZeroLeft(value, size) : (BigInteger.class.isAssignableFrom(fieldType) ? new BigInteger(value.toString()) : (BigDecimal.class.isAssignableFrom(fieldType) ? new BigDecimal(value.toString()) : (Integer.class.isAssignableFrom(fieldType) ? (Number)value.intValue() : (Number)(Long.class.isAssignableFrom(fieldType) ? (Number)value.longValue() : (Number)value))));
        ReflectionUtils.setValue((Object)entity, field, fieldType, convertedValue);
    }
}

