/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.secret;

import br.com.jarch.core.annotation.JArchConfidential;
import br.com.jarch.core.annotation.JArchService;
import br.com.jarch.core.crud.secret.SecretEntity;
import br.com.jarch.core.crud.secret.SecretRepository;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.core.exception.SecretException;
import br.com.jarch.core.model.IBaseEntity;
import br.com.jarch.core.model.ISecretData;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.core.model.type.ActionCrudType;
import br.com.jarch.core.util.BundleUtils;
import java.lang.annotation.Annotation;
import java.time.LocalDateTime;
import javax.enterprise.inject.spi.CDI;
import javax.transaction.Transactional;

@JArchService
public class SecretService
extends CrudService<SecretEntity, SecretRepository> {
    public static SecretService getInstance() {
        return (SecretService)CDI.current().select(SecretService.class, new Annotation[0]).get();
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void saveDataConfidential(IBaseEntity entity, ActionCrudType action) {
        JArchConfidential annotation;
        if (!entity.getClass().isAnnotationPresent(JArchConfidential.class)) {
            return;
        }
        if (UserInformation.getInstance().isNotExists()) {
            throw new SecretException(BundleUtils.messageBundle("message.usuarioNaoLocalizadoSessao"));
        }
        Object entityName = null;
        if (entity.getClass().isAnnotationPresent(JArchConfidential.class) && !(annotation = entity.getClass().getAnnotation(JArchConfidential.class)).value().isBlank()) {
            entityName = BundleUtils.messageBundle(annotation.value());
        }
        if (entityName == null) {
            entityName = entity.getClass().getSimpleName().replace("Entity", "");
            entityName = ((String)entityName).substring(0, 1).toLowerCase() + ((String)entityName).substring(1);
            entityName = BundleUtils.exists((String)(entityName = "label." + (String)entityName)) ? BundleUtils.messageBundle((String)entityName) : entity.getClass().getSimpleName();
        }
        SecretEntity secret = (SecretEntity)this.createEntity();
        secret.setAction(action);
        secret.setDateHour(LocalDateTime.now());
        Object userInformation = UserInformation.getInstance().get();
        secret.setUser(userInformation.getId());
        secret.setLogin(userInformation.getLogin() + " - " + userInformation.getNome());
        secret.setEntityId(entity.getId());
        secret.setEntityName((String)entityName);
        secret.setData(((ISecretData)((Object)entity)).getData());
        this.insert(secret);
    }
}

