/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.search;

import br.com.jarch.core.annotation.JArchSearchFieldLookup;
import br.com.jarch.core.annotation.JArchSearchTab;
import br.com.jarch.core.crud.search.BaseFieldSearchFactory;
import br.com.jarch.core.crud.search.FieldSearch;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;

final class FieldSearchLookupFactory
extends BaseFieldSearchFactory {
    FieldSearchLookupFactory() {
    }

    void createFieldSearch(Class<?> classEntityOrController, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        this.createFromFields(classEntityOrController, mapFieldSearch);
        this.createFromClass(classEntityOrController, mapFieldSearch);
        this.createFromPackage(classEntityOrController, mapFieldSearch, onlyThisClass);
    }

    private void createFromFields(Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        for (Field field : ReflectionUtils.getArrayFields(classActionEntity, true, true)) {
            Arrays.stream((JArchSearchFieldLookup[])field.getAnnotationsByType(JArchSearchFieldLookup.class)).forEach(a -> this.addFieldSearch(null, classActionEntity, (JArchSearchFieldLookup)a, field, mapFieldSearch));
            for (JArchSearchTab searchTab : (JArchSearchTab[])field.getAnnotationsByType(JArchSearchTab.class)) {
                Arrays.stream(searchTab.searchFieldLookups()).forEach(a -> this.addFieldSearch(searchTab, classActionEntity, (JArchSearchFieldLookup)a, field, mapFieldSearch));
            }
        }
    }

    private void createFromPackage(Class<?> classControllerOrEntity, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        Class<?> classEntity = this.getClassEntityFrom(classControllerOrEntity);
        this.createFromSearchTab(null, classEntity, (JArchSearchFieldLookup[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchFieldLookup.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromSearchTab(searchTab, classEntity, searchTab.searchFieldLookups(), mapFieldSearch);
        }
        if (onlyThisClass || classEntity.equals(classControllerOrEntity) || classEntity.getPackage().equals(classControllerOrEntity.getPackage())) {
            return;
        }
        this.createFromSearchTab(null, classEntity, (JArchSearchFieldLookup[])classEntity.getPackage().getAnnotationsByType(JArchSearchFieldLookup.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromSearchTab(searchTab, classEntity, searchTab.searchFieldLookups(), mapFieldSearch);
        }
    }

    private void createFromSearchTab(JArchSearchTab searchTab, Class<?> classEntity, JArchSearchFieldLookup[] searchFields, Map<String, FieldSearch> mapFieldSearch) {
        for (JArchSearchFieldLookup searchField : searchFields) {
            if (searchField.classEntity() != Void.TYPE && searchField.classEntity() != classEntity || searchTab != null && searchTab.classEntity() != classEntity) continue;
            String fieldName = searchField.field();
            Field field = searchField.classEntity() != Void.TYPE ? ReflectionUtils.getField(searchField.classEntity(), fieldName, true) : ReflectionUtils.getField(classEntity, fieldName, true);
            this.addFieldSearch(searchTab, classEntity, searchField, field, mapFieldSearch);
        }
    }

    private void createFromClass(Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        this.createFromClass(null, classActionEntity, (JArchSearchFieldLookup[])classActionEntity.getAnnotationsByType(JArchSearchFieldLookup.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classActionEntity.getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromClass(searchTab, classActionEntity, searchTab.searchFieldLookups(), mapFieldSearch);
        }
    }

    private void createFromClass(JArchSearchTab searchTab, Class<?> classActionEntity, JArchSearchFieldLookup[] searchFields, Map<String, FieldSearch> mapFieldSearch) {
        for (JArchSearchFieldLookup searchFieldLookup : searchFields) {
            Class<Object> classEntity = IIdentity.class.isAssignableFrom(classActionEntity) ? classActionEntity : ReflectionUtils.getGenericClass(classActionEntity, 0);
            String fieldName = searchFieldLookup.field();
            Field field = searchFieldLookup.classEntity() == Void.TYPE ? ReflectionUtils.getField(classEntity, fieldName, false) : ReflectionUtils.getField(searchFieldLookup.classEntity(), fieldName, false);
            this.addFieldSearch(searchTab, classActionEntity, searchFieldLookup, field, mapFieldSearch);
        }
    }

    private void addFieldSearch(JArchSearchTab searchTab, Class<?> classEntity, JArchSearchFieldLookup searchFieldLookup, Field field, Map<String, FieldSearch> mapFieldSearch) {
        try {
            if (Boolean.FALSE.equals(searchFieldLookup.enable().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getAsBoolean())) {
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        classEntity = searchTab != null && searchTab.classEntity() != Void.TYPE ? searchTab.classEntity() : classEntity;
        String fieldName = searchFieldLookup.field();
        String atributo = fieldName.isEmpty() && field != null ? field.getName() : fieldName;
        String descricao = searchFieldLookup.label() == null || searchFieldLookup.label().isEmpty() ? "label.".concat(atributo) : searchFieldLookup.label();
        descricao = BundleUtils.messageBundle(descricao);
        String id = this.createId(classEntity, searchFieldLookup.id(), atributo, mapFieldSearch);
        FieldSearch fieldSearch = FieldSearch.createInstance().annotation(JArchSearchFieldLookup.class).id(id).clearValueByButton(!searchFieldLookup.hide()).classAttribute(searchFieldLookup.classEntity()).attribute(atributo).description(descricao).type(FieldType.ENTITY).mask(searchFieldLookup.mask()).condition(ConditionSearchType.EQUAL).row(searchFieldLookup.row()).column(searchFieldLookup.column()).span(searchFieldLookup.span()).where(searchFieldLookup.whereJpa()).tooltip(searchFieldLookup.toolTip().isEmpty() ? "" : BundleUtils.messageBundle(searchFieldLookup.toolTip())).classEntityLookup(searchFieldLookup.classEntityLookup()).classFilterSelectController(searchFieldLookup.classFilterSelectController()).tabName(searchTab == null ? "label.main" : searchTab.name()).tabOrder(searchTab == null ? 0 : searchTab.order()).hideCode(searchFieldLookup.hideCode()).hide(searchFieldLookup.hide()).others(searchFieldLookup.others());
        mapFieldSearch.put(id, fieldSearch);
    }
}

