/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.report;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import br.com.jarch.core.crud.report.FileResultDto;
import br.com.jarch.core.crud.report.IReportList;
import br.com.jarch.core.crud.search.ISearch;
import br.com.jarch.core.excel.ExcelUtils;
import br.com.jarch.core.model.IColumnList;
import br.com.jarch.core.report.ReportBuilder;
import br.com.jarch.core.report.ReportGroup;
import br.com.jarch.core.report.ReportGroupBuilder;
import br.com.jarch.core.type.FileType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import org.apache.commons.io.output.ByteArrayOutputStream;

@Dependent
public class ReportList
implements IReportList {
    @Override
    public FileResultDto exportFormatExcel(Collection<?> listData, List<IColumnList> columnsList, String labelReport) {
        try (ByteArrayOutputStream fos = new ByteArrayOutputStream();){
            FileResultDto fileResultDto = this.getInputStreamExcel(listData, columnsList, labelReport, fos);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        return null;
    }

    private FileResultDto getInputStreamExcel(Collection<?> listData, List<IColumnList> columnsList, String labelReport, ByteArrayOutputStream fos) throws IOException {
        List<Map<String, Object>> listaRegistro = ReportList.listRecord(listData, columnsList);
        ExcelUtils.generate("Listagem", BundleUtils.messageBundle("label.relatorioDe") + " " + labelReport, listaRegistro, (OutputStream)fos);
        ByteArrayInputStream stream = new ByteArrayInputStream(fos.toByteArray());
        return new FileResultDto(FileType.EXCEL, stream);
    }

    @Override
    public FileResultDto exportFormatCsv(Collection<?> listData, List<IColumnList> columnsList, String labelReport) {
        try {
            return this.getInputStreamCsv(listData, columnsList);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return null;
        }
    }

    private FileResultDto getInputStreamCsv(Collection<?> listData, List<IColumnList> columnsList) throws IOException {
        List<Map<String, Object>> listDataRecord = ReportList.listRecord(listData, columnsList);
        StringBuilder sbResult = ReportList.generateCsv(listDataRecord, columnsList);
        ByteArrayInputStream stream = new ByteArrayInputStream(sbResult.toString().getBytes());
        return new FileResultDto(FileType.CSV, stream);
    }

    private static StringBuilder generateCsv(Collection<Map<String, Object>> listData, List<IColumnList> columnsList) throws IOException {
        StringBuilder result = new StringBuilder();
        if (listData.isEmpty()) {
            return result;
        }
        String header = columnsList.stream().map(IColumnList::getTitle).collect(Collectors.joining(";"));
        result.append(header);
        result.append("\n");
        for (Map<String, Object> registro : listData) {
            for (Object value : registro.values()) {
                result.append(value).append(";");
            }
            result.append("\n");
        }
        return result;
    }

    @Override
    public FileResultDto exportFormatTxt(ISearch<?> search, Collection<?> listaDados, List<IColumnList> columnsList, Collection<Map<String, String>> listGroup, Collection<Map<String, String>> listOrder, String templateReport, boolean reportPortrait, String labelReport) {
        try {
            ReportBuilder reportBuilder = this.getReportBuilderTxt(search, listaDados, columnsList, listGroup, listOrder, reportPortrait, labelReport);
            return reportBuilder.exportFormatTxt(labelReport);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return null;
        }
    }

    private ReportBuilder getReportBuilderTxt(ISearch<?> search, Collection<?> listaDados, List<IColumnList> columnsList, Collection<Map<String, String>> listGroup, Collection<Map<String, String>> listOrder, boolean reportPortrait, String labelReport) {
        Class<?> classEntity = search.getClassReturn();
        Object agrupamento = "";
        if (listGroup != null) {
            agrupamento = BundleUtils.messageBundle("label.agrupamento") + ": " + listGroup.stream().map(m -> (String)m.get("label")).collect(Collectors.joining(", "));
        }
        Object ordenacao = "";
        if (listOrder != null) {
            ordenacao = BundleUtils.messageBundle("label.ordenacao") + ": " + listOrder.stream().map(m -> (String)m.get("label")).collect(Collectors.joining(", "));
        }
        ReportBuilder reportBuilder = ReportBuilder.createInstance().setTitle(BundleUtils.messageBundle("label.relatorioDe") + " " + labelReport).setSubtitle(search.getDescriptionFilter() + " - " + (String)agrupamento + " - " + (String)ordenacao).withListData(listaDados);
        reportBuilder.addGrandTotalLegend("");
        if (reportPortrait) {
            reportBuilder.withPortraitOrientation();
        } else {
            reportBuilder.withLandscapeOrientation();
        }
        this.configColumns(reportBuilder, classEntity, columnsList, listGroup);
        return reportBuilder;
    }

    @Override
    public FileResultDto exportFormatXml(Collection<?> listData, List<IColumnList> columnsList, String labelReport) {
        try {
            return this.getInputStreamXml(listData, columnsList);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return null;
        }
    }

    private FileResultDto getInputStreamXml(Collection<?> listData, List<IColumnList> columnsList) throws IOException {
        List<Map<String, Object>> listDataRecord = ReportList.listRecord(listData, columnsList);
        Optional<?> optional = listData.stream().findAny();
        StringBuilder sbResult = ReportList.generateXml(optional.get().getClass(), listDataRecord, columnsList);
        ByteArrayInputStream stream = new ByteArrayInputStream(sbResult.toString().getBytes());
        return new FileResultDto(FileType.XML, stream);
    }

    private static StringBuilder generateXml(Class<?> clazz, Collection<Map<String, Object>> listData, List<IColumnList> columnsList) {
        StringBuilder result = new StringBuilder();
        if (listData.isEmpty()) {
            return result;
        }
        String className = clazz.getSimpleName().replace("Entity", "");
        String firstTag = "lista" + className;
        result.append("<").append(firstTag).append(">\n");
        className = CharacterUtils.firstCaracterLowerCase(className);
        for (Map<String, Object> registro : listData) {
            result.append("<").append(className).append(">\n");
            for (Map.Entry<String, Object> item : registro.entrySet()) {
                String field;
                Optional<IColumnList> optional = columnsList.stream().filter(c -> c.getTitle().equals(item.getKey())).findAny();
                String string = field = optional.isPresent() ? optional.get().getField() : "desconhecido";
                field = optional.get().isDynamicColumn() ? field.replace("dynamicColumn.", "") : field.substring(0, field.indexOf(".") > 0 ? field.indexOf(".") : field.length());
                result.append("<").append(field).append(">");
                Object value = String.valueOf(item.getValue());
                value = ((String)value).replace("&", "&amp;").replace("\u2019", "&apos;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
                result.append((String)value);
                result.append("</").append(field).append(">\n");
            }
            result.append("</").append(className).append(">\n");
        }
        result.append("</").append(firstTag).append(">");
        return result;
    }

    @Override
    public FileResultDto exportFormatPdf(ISearch<?> search, Collection<?> listaDados, List<IColumnList> columnsList, Collection<Map<String, String>> listGroup, Collection<Map<String, String>> listOrder, String templateReport, boolean reportPortrait, String labelReport) {
        try {
            ReportBuilder reportBuilderPdf = this.getReportBuilder(search, listaDados, columnsList, listGroup, listOrder, reportPortrait, labelReport);
            return reportBuilderPdf.exportFormatPdf(labelReport);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return null;
        }
    }

    private ReportBuilder getReportBuilder(ISearch<?> search, Collection<?> listaDados, List<IColumnList> columnsList, Collection<Map<String, String>> listGroup, Collection<Map<String, String>> listOrder, boolean reportPortrait, String labelReport) {
        Class<?> classEntity = search.getClassReturn();
        Object agrupamento = "";
        if (listGroup != null) {
            agrupamento = BundleUtils.messageBundle("label.agrupamento") + ": " + listGroup.stream().map(m -> (String)m.get("label")).collect(Collectors.joining(", "));
        }
        Object ordenacao = "";
        if (listOrder != null) {
            ordenacao = BundleUtils.messageBundle("label.ordenacao") + ": " + listOrder.stream().map(m -> (String)m.get("label")).collect(Collectors.joining(", "));
        }
        ReportBuilder reportBuilder = ReportBuilder.createInstance().setTitle(BundleUtils.messageBundle("label.relatorioDe") + " " + labelReport).setSubtitle(search.getDescriptionFilter() + " - " + (String)agrupamento + " - " + (String)ordenacao).withListData(listaDados);
        reportBuilder.addGrandTotalLegend("");
        if (reportPortrait) {
            reportBuilder.withPortraitOrientation();
        } else {
            reportBuilder.withLandscapeOrientation();
        }
        this.configColumns(reportBuilder, classEntity, columnsList, listGroup);
        return reportBuilder;
    }

    @Override
    public void configColumns(ReportBuilder reportBuilder, Class<?> classEntity, List<IColumnList> columnsList, Collection<Map<String, String>> listaGroup) {
        ArrayList<String> listaCampoNumerico = new ArrayList<String>();
        int indexColumn = 0;
        for (IColumnList iColumnList : columnsList) {
            Method method;
            Field field;
            Class classAttribute = iColumnList.getField().startsWith("dynamicColumn") ? String.class : (ReflectionUtils.isAttribute(classEntity, iColumnList.getField(), true) ? ((field = ReflectionUtils.getField(classEntity, iColumnList.getField())) == null ? iColumnList.getType().getClassType() : field.getType()) : ((method = ReflectionUtils.getGetter(classEntity, "get" + iColumnList.getField().substring(0, 1).toUpperCase() + iColumnList.getField().substring(1), true)) == null ? iColumnList.getType().getClassType() : method.getReturnType()));
            int width = iColumnList.getWidth() == 0 ? iColumnList.getType().getWidthXhtml() : iColumnList.getWidth();
            reportBuilder.addField(iColumnList.getTitle(), iColumnList.getField(), width, classAttribute);
            if (++indexColumn == 1) {
                reportBuilder.addGlobalFooterVariable("\n" + BundleUtils.messageBundle("label.total") + " - ", iColumnList.getField(), DJCalculation.COUNT);
                continue;
            }
            if (Number.class.isAssignableFrom(classAttribute) && iColumnList.isTotalize()) {
                listaCampoNumerico.add(iColumnList.getField());
                reportBuilder.addGlobalFooterVariable(iColumnList.getField(), DJCalculation.SUM);
                continue;
            }
            reportBuilder.addGlobalFooterVariable(iColumnList.getField(), DJCalculation.SYSTEM);
        }
        for (Map map : listaGroup) {
            ReportGroupBuilder reportGroupBuilder = ReportGroupBuilder.createInstance(reportBuilder, (String)map.get("attribute"));
            reportGroupBuilder.setGroupLayout(new GroupLayout(true, true, true, false, false));
            for (String campo : listaCampoNumerico) {
                reportGroupBuilder = reportGroupBuilder.addFooterVariable(campo, DJCalculation.SUM);
            }
            ReportGroup reportGroup = reportGroupBuilder.build();
            reportBuilder.addGroup(reportGroup);
        }
    }

    public static List<Map<String, Object>> listRecord(Collection<?> listData, List<IColumnList> columnsList) {
        return listData.stream().map(line -> {
            LinkedHashMap mapRegistro = new LinkedHashMap();
            columnsList.stream().filter(c -> !c.getField().contains(".")).forEach(column -> {
                Object valorOriginal;
                if (column.isDynamicColumn()) {
                    String columnName = column.getField().replace("dynamicColumn.", "");
                    valorOriginal = ((Map)ReflectionUtils.getValueByName(line, "dynamicColumn")).get(columnName);
                } else {
                    valorOriginal = ReflectionUtils.getValueByName(line, column.getField());
                }
                String valorFormatado = column.getType().format(valorOriginal);
                mapRegistro.put(column.getTitle(), valorFormatado);
            });
            return mapRegistro;
        }).collect(Collectors.toList());
    }
}

