/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.parameter;

import br.com.jarch.core.crud.parameter.BaseParameterEntity;
import br.com.jarch.core.crud.parameter.BaseParameterRepository;
import br.com.jarch.core.crud.parameter.IParameter;
import br.com.jarch.core.crud.parameter.Parameter;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import br.com.jarch.util.StringUtils;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import javax.inject.Inject;

public abstract class BaseParameterService<E extends BaseParameterEntity, R extends BaseParameterRepository<E>>
extends CrudService<E, R> {
    @Inject
    private R repository;

    public <T extends Parameter<?, ?>> T getParameter(Class<? extends T> classParameter) {
        try {
            Parameter parameter = (Parameter)classParameter.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.configBeanFromEntity(parameter);
            return (T)parameter;
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return null;
        }
    }

    public void configBeanFromEntity(Parameter<?, ?> parameter) {
        this.repository.findBySystemKey(parameter).stream().findAny().ifPresentOrElse(e -> {
            parameter.setId(e.getId());
            parameter.setDescription(e.getDescription());
            parameter.setExplanation(e.getExplanation());
            parameter.setValueBinary(e.getValueBinary());
            parameter.setValueString(e.getValueString());
            parameter.setValueMemo(e.getValueMemo());
            parameter.setValueDecimal(e.getValueDecimal());
            parameter.setValueInteger(e.getValueInteger());
            parameter.setValueDateTime(e.getValueDateTime());
            parameter.setValueOtherInformation(e.getValueOtherInformation());
        }, () -> {
            parameter.setId(null);
            parameter.setDescription(parameter.description());
            parameter.setExplanation(parameter.explanation());
            parameter.setValueBinary(null);
            parameter.setValueString(null);
            parameter.setValueMemo(null);
            parameter.setValueDecimal(null);
            parameter.setValueInteger(null);
            parameter.setValueDateTime(null);
            parameter.setValueOtherInformation(null);
        });
    }

    public void save(IParameter<?> parameter) {
        this.saveParameter(parameter);
    }

    private void saveParameter(IParameter<?> parameter) {
        try {
            BaseParameterService.validRequired(parameter);
            parameter.valid();
            BaseParameterEntity entity = parameter.getId() == null || parameter.getId() == 0L ? (BaseParameterEntity)ReflectionUtils.createInstance(this.getClassEntity()) : this.repository.findAny(parameter.getId()).orElse((BaseParameterEntity)ReflectionUtils.createInstance(this.getClassEntity()));
            entity.setSistema(parameter.system());
            entity.setCategoria(parameter.category());
            entity.setChave(parameter.key());
            String classeConteudo = parameter.isCollection() ? ((ParameterizedType)parameter.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName() : (parameter.getValue() == null ? ReflectionUtils.getGenericClass(parameter.getClass(), 0).getName() : parameter.getValue().getClass().getName());
            entity.setClasseConteudo(classeConteudo);
            entity.setValueBinary(parameter.getValueBinary());
            entity.setValueMemo(parameter.getValueMemo());
            entity.setValueString(parameter.getValueString());
            entity.setValueDecimal(parameter.getValueDecimal());
            entity.setValueInteger(parameter.getValueInteger());
            entity.setValueDateTime(parameter.getValueDateTime());
            entity.setDescription(parameter.description());
            entity.setExplanation(parameter.explanation());
            entity.setValueOtherInformation(parameter.getValueOtherInformation());
            entity.setMultiTenantId(parameter.isMultiTenant() ? MultiTenant.getInstance().get() : 0L);
            if (entity.getId() == null) {
                this.insert(entity);
            } else {
                this.change(entity);
            }
            parameter.setId(entity.getId());
            parameter.reload();
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            throw new ValidationException(ex);
        }
    }

    private static void validRequired(IParameter<?> parameter) {
        if (!parameter.isRequired()) {
            return;
        }
        if (parameter.getValue() == null) {
            throw new ValidationException(BundleUtils.messageBundleParam("message.required", "#" + parameter.description()));
        }
        if (parameter.getValue().getClass().isArray() && ((Object[])parameter.getValue()).length == 0) {
            throw new ValidationException(BundleUtils.messageBundleParam("message.required", "#" + parameter.description()));
        }
        if (Collection.class.isAssignableFrom(parameter.getValue().getClass()) && ((Collection)parameter.getValue()).isEmpty()) {
            throw new ValidationException(BundleUtils.messageBundleParam("message.required", "#" + parameter.description()));
        }
        if (StringUtils.isNullOrEmpty(parameter.getValue().toString())) {
            throw new ValidationException(BundleUtils.messageBundleParam("message.required", "#" + parameter.description()));
        }
    }
}

