/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.listener;

import br.com.jarch.core.annotation.JArchConfidential;
import br.com.jarch.core.crud.secret.SecretService;
import br.com.jarch.core.model.IBaseEntity;
import br.com.jarch.core.model.type.ActionCrudType;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;

public class ConfidentialJpaListener {
    @PostPersist
    public void posPersist(IBaseEntity baseEntity) {
        this.persistDataBase(baseEntity, ActionCrudType.INSERT);
    }

    @PostUpdate
    public void postUpdate(IBaseEntity baseEntity) {
        this.persistDataBase(baseEntity, ActionCrudType.CHANGE);
    }

    @PostRemove
    public void postRemove(IBaseEntity baseEntity) {
        this.persistDataBase(baseEntity, ActionCrudType.DELETE);
    }

    @PostLoad
    public void postLoad(IBaseEntity baseEntity) {
        this.persistDataBase(baseEntity, ActionCrudType.CONSULT);
    }

    public void persistDataBase(IBaseEntity baseEntity, ActionCrudType action) {
        if (!baseEntity.getClass().isAnnotationPresent(JArchConfidential.class)) {
            return;
        }
        SecretService.getInstance().saveDataConfidential(baseEntity, action);
    }
}

