/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.jparepository;

import br.com.jarch.core.annotation.JArchEventReadEntityManager;
import br.com.jarch.core.crud.util.AutoIncrementUtils;
import br.com.jarch.core.jpa.api.ClientJpql;
import br.com.jarch.util.LogUtils;
import java.util.Arrays;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Dependent
public class EntityManagerProduces {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    @JArchEventReadEntityManager
    private Event<EntityManager> eventProduceEntityManager;

    @Produces
    public EntityManager createEntityManager(InjectionPoint injectionPoint) {
        if (!EntityManagerProduces.isClientJpql() && !EntityManagerProduces.isAutoIncrementUtils() && injectionPoint.getMember() == null) {
            LogUtils.warning("WESA: Ponto de inje\u00e7\u00e3o do EntityManager desconhecido, utilizar EntityManagerUtils.addFilter para garantir os filtros necess\u00e1rios...");
        }
        this.eventProduceEntityManager.fire(this.entityManager);
        return this.entityManager;
    }

    private static boolean isClientJpql() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return Arrays.stream(ste).anyMatch(p -> p.getClassName().contains(ClientJpql.class.getSimpleName()));
    }

    private static boolean isAutoIncrementUtils() {
        Throwable thr = new Throwable();
        thr.fillInStackTrace();
        StackTraceElement[] ste = thr.getStackTrace();
        return Arrays.stream(ste).anyMatch(p -> p.getClassName().contains(AutoIncrementUtils.class.getSimpleName()));
    }
}

