/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.annotation;

import br.com.jarch.core.exception.BaseException;
import br.com.jarch.core.exception.ReflectionException;
import br.com.jarch.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class AnnotationUtils {
    private static final String ANNOTATION_DATA = "annotationData";
    private static final String ANNOTATION_DECLARED = "declaredAnnotations";
    private static final String ANNOTATIONS = "annotations";

    private AnnotationUtils() {
    }

    public static void addAnnotationClass(Class<?> targetClass, Class<? extends Annotation> targetAnnotation, Annotation targetValue) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AnnotationUtils.addAnnotationClass(targetClass, targetAnnotation, targetValue, false);
    }

    public static void addDeclarationAnnotationClass(Class<?> targetClass, Class<? extends Annotation> targetAnnotation, Annotation targetValue) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AnnotationUtils.addAnnotationClass(targetClass, targetAnnotation, targetValue, true);
    }

    public static <A extends Annotation> void processMethodAnnotedIntoInstance(Class<A> classAnnotation, Object instance) {
        List methods = Arrays.stream(instance.getClass().getMethods()).collect(Collectors.toList());
        methods.addAll(Arrays.stream(instance.getClass().getDeclaredMethods()).collect(Collectors.toList()));
        methods.stream().filter(method -> method.getAnnotation(classAnnotation) != null).distinct().forEach(method -> AnnotationUtils.callMethod(instance, method));
    }

    public static <A extends Annotation> void processMethodAnnotedIntoInstance(Class<A> classAnnotation, Object instance, Object ... params) {
        List methods = Arrays.stream(instance.getClass().getMethods()).collect(Collectors.toList());
        methods.addAll(Arrays.stream(instance.getClass().getDeclaredMethods()).collect(Collectors.toList()));
        methods.stream().filter(method -> method.getAnnotation(classAnnotation) != null).distinct().forEach(method -> AnnotationUtils.callMethodParams(instance, method, params));
    }

    private static void addAnnotationClass(Class<?> targetClass, Class<? extends Annotation> targetAnnotation, Annotation targetValue, boolean declared) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = Class.class.getDeclaredMethod(ANNOTATION_DATA, new Class[0]);
        method.setAccessible(true);
        Object annotationData = method.invoke(targetClass, new Object[0]);
        Field annotations = annotationData.getClass().getDeclaredField(declared ? ANNOTATION_DECLARED : ANNOTATIONS);
        annotations.setAccessible(true);
        Map map = (Map)annotations.get(annotationData);
        map.put(targetAnnotation, targetValue);
    }

    private static void callMethod(Object instance, Method method) {
        try {
            ReflectionUtils.executeMethod(instance, method, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            if (ex.getCause() != null && BaseException.class.isAssignableFrom(ex.getCause().getClass())) {
                throw new ReflectionException((BaseException)ex.getCause());
            }
            throw new ReflectionException(ex);
        }
    }

    private static void callMethodParams(Object instance, Method method, Object[] params) {
        try {
            ReflectionUtils.executeMethod(instance, method, params);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            if (ex.getCause() != null && BaseException.class.isAssignableFrom(ex.getCause().getClass())) {
                throw new ReflectionException((BaseException)ex.getCause());
            }
            throw new ReflectionException(ex);
        }
    }
}

