/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.util;

import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.core.annotation.JArchApplicationScoped;
import br.com.jarch.core.annotation.JArchColumnDataTable;
import br.com.jarch.core.annotation.JArchColumnsDataTable;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.annotation.JArchRequestScoped;
import br.com.jarch.core.annotation.JArchSearchField;
import br.com.jarch.core.annotation.JArchSearchFieldCheckbox;
import br.com.jarch.core.annotation.JArchSearchFieldCombobox;
import br.com.jarch.core.annotation.JArchSearchFieldComboboxCommandJpa;
import br.com.jarch.core.annotation.JArchSearchFieldLookup;
import br.com.jarch.core.annotation.JArchSearchTab;
import br.com.jarch.core.annotation.JArchSessionScoped;
import br.com.jarch.core.annotation.JArchViewScoped;
import br.com.jarch.core.crud.jparepository.BaseJpaRepository;
import br.com.jarch.core.crud.repository.BaseRepository;
import br.com.jarch.core.exception.ProcessorException;
import br.com.jarch.core.form.FieldForm;
import br.com.jarch.core.model.IBaseMultiTenantEntity;
import br.com.jarch.core.model.ICrudMultiTenantEntity;
import br.com.jarch.core.model.ISecretData;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.util.CharacterUtils;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.faces.view.ViewScoped;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Filters;

public final class ProcessorUtils {
    public static final String ENTITY = "Entity";
    public static final String PACKAGE = "package ";
    public static final String MESSAGE_ATRIBUTE_NO_FILTER_TENANT = "JARCH ERROR: Atributo de relacionamento com outra entidade sem anota\u00e7\u00e3o de filtro de tenant @Filter(name = ConstantCore.TENANT)";
    public static final String CLAZZ_ENTITY_EQUAL_VOID = "clazzEntity=void";
    public static final String CLASS_ENTITY_EQUAL_VOID = "classEntity=void";
    public static final String CLIENT = "client";
    public static final String MINUS_CLIENT = "-client";
    public static ProcessingEnvironment processingEnvironment;

    private ProcessorUtils() {
    }

    public static void messageMandatoryWarning(String message) {
        ProcessorUtils.messageMandatoryWarning(message, null);
    }

    public static void messageMandatoryWarning(String message, Element element) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, message, element);
    }

    public static void messageWarning(String message, Element element) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
    }

    public static void messageNote(String message) {
        ProcessorUtils.messageNote(message, null);
    }

    public static void messageNote(String message, Element element) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.NOTE, message, element);
    }

    public static void messageOther(String message, Element element) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.OTHER, message, element);
    }

    public static void messageError(String message) {
        ProcessorUtils.messageError(message, null);
    }

    public static void messageError(String message, Element element) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, ProcessorUtils.formatMessageErro(message), element);
    }

    public static void message(Diagnostic.Kind kind, String message, Element element) {
        if (Diagnostic.Kind.ERROR == kind) {
            message = ProcessorUtils.formatMessageErro(message);
        }
        processingEnvironment.getMessager().printMessage(kind, message, element);
    }

    public static String getPackage(Element element, String nameSubPackage) {
        String retorno = ProcessorUtils.getPathSource(element, nameSubPackage);
        int posicao = retorno.indexOf(File.separator + "src" + File.separator);
        if (posicao > 0) {
            retorno = retorno.substring(posicao += 5);
            if ((retorno = retorno.replace(File.separator, ".")).startsWith("main.java.")) {
                retorno = retorno.replace("main.java.", "");
            }
        }
        if (retorno.endsWith(".")) {
            retorno = retorno.substring(0, retorno.length() - 1);
        }
        return retorno;
    }

    public static String getPathSource(Element element, String nameSubPackage) {
        String subPackage;
        String result = Trees.instance(processingEnvironment).getPath(element).getCompilationUnit().getSourceFile().toString();
        String string = subPackage = nameSubPackage == null || nameSubPackage.isEmpty() ? "" : nameSubPackage.concat(File.separator);
        if (result.startsWith("SimpleFileObject")) {
            return result.replace("SimpleFileObject[", "").replace("]", "").replace("package-info.java", "").concat(subPackage);
        }
        return result.replace("RegularFileObject[", "").replace("]", "").replace("package-info.java", "").concat(subPackage);
    }

    public static String getPathTest(Element element, String nameSubPackage) {
        return ProcessorUtils.getPathSource(element, nameSubPackage).replace(File.separator + "main" + File.separator, File.separator + "test" + File.separator);
    }

    public static String getPathBundle(Element element, String nameSubPackage) {
        return ProcessorUtils.getPathSource(element, nameSubPackage).substring(0, ProcessorUtils.getPathSource(element, nameSubPackage).lastIndexOf("java" + File.separator)).concat("resources" + File.separator + "bundle" + File.separator);
    }

    public static String getPathPage(Element element, String nameSubPackage) {
        String pathSource = ProcessorUtils.getPathSource(element, nameSubPackage);
        return pathSource.substring(0, pathSource.indexOf("main" + File.separator + "java" + File.separator) + 5).concat("webapp" + File.separator + "paginas" + File.separator).concat(nameSubPackage).concat(File.separator).replace(MINUS_CLIENT, "-web");
    }

    public static String getNameWithoutCharEspecialCapitalize(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        String nameWithoutCharEspecial = CharacterUtils.removeCharEspecial(name);
        String nameOnlyCharOrNumber = CharacterUtils.onlyNumberOrLetter(nameWithoutCharEspecial);
        String nameWithoutSpace = nameOnlyCharOrNumber.replace(" ", "");
        return nameWithoutSpace.substring(0, 1).toUpperCase().concat(nameWithoutSpace.substring(1));
    }

    public static String getNameWithoutCharEspecialStartLowerCase(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        String nameWithoutCharEspecialCapitalize = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        return nameWithoutCharEspecialCapitalize.substring(0, 1).toLowerCase() + nameWithoutCharEspecialCapitalize.substring(1);
    }

    public static String getNomeEntity(String name) {
        return CharacterUtils.onlyNumberOrLetter(CharacterUtils.removeCharEspecial(name).replace(" ", "")).concat(ENTITY);
    }

    public static String namePrimaryKey(String tableName) {
        return "PK_" + tableName.substring(3).replace("_", "").toLowerCase();
    }

    public static String nameSequence(String tableName) {
        return "sq_id" + tableName.substring(3).replace("_", "").toLowerCase();
    }

    public static String nameIdColumn(String tableName) {
        return "id_" + tableName.substring(3).replace("_", "").toLowerCase();
    }

    public static void addCode(StringBuilder sb, String value) {
        sb.append(value.concat("\n"));
    }

    public static void addLineBlank(StringBuilder sb) {
        sb.append("\n");
    }

    public static List<FieldForm> getListFieldForm(JArchGenerateCrud.Field[] fields) {
        return Arrays.stream(fields).map(f -> new FieldForm(f.fieldName(), f.fieldTable(), f.description(), f.type(), f.search(), f.xhtml(), f.required(), f.exclusive(), f.codeLookup(), f.descriptionLookup())).collect(Collectors.toList());
    }

    public static void validFilterTenant(Element element) {
        Filters anotacaoFilters;
        if (element.getKind() == ElementKind.METHOD) {
            return;
        }
        TypeMirror baseMultiTenant = processingEnvironment.getElementUtils().getTypeElement(IBaseMultiTenantEntity.class.getName()).asType();
        TypeMirror crudMultiTenant = processingEnvironment.getElementUtils().getTypeElement(ICrudMultiTenantEntity.class.getName()).asType();
        if (element.asType().toString().contains("<")) {
            String classGenericCollection = element.asType().toString().substring(element.asType().toString().indexOf(60)).replace("<", "").replace(">", "");
            try {
                if (processingEnvironment.getElementUtils().getTypeElement(classGenericCollection) == null) {
                    return;
                }
                TypeMirror elementCollection = processingEnvironment.getElementUtils().getTypeElement(classGenericCollection).asType();
                if (!processingEnvironment.getTypeUtils().isSubtype(elementCollection, baseMultiTenant) && !processingEnvironment.getTypeUtils().isSubtype(elementCollection, crudMultiTenant)) {
                    return;
                }
            }
            catch (Exception ex) {
                ProcessorUtils.messageError(classGenericCollection + ": " + ex.getMessage(), element);
            }
        } else if (!processingEnvironment.getTypeUtils().isSubtype(element.asType(), baseMultiTenant) && !processingEnvironment.getTypeUtils().isSubtype(element.asType(), crudMultiTenant)) {
            return;
        }
        if ((anotacaoFilters = element.getAnnotation(Filters.class)) == null) {
            Filter anotacaoFilter = element.getAnnotation(Filter.class);
            if (anotacaoFilter == null || !anotacaoFilter.name().contains("tenant")) {
                ProcessorUtils.messageError(MESSAGE_ATRIBUTE_NO_FILTER_TENANT, element);
            }
        } else if (Arrays.stream(anotacaoFilters.value()).noneMatch(a -> a.name().contains("tenant"))) {
            ProcessorUtils.messageError(MESSAGE_ATRIBUTE_NO_FILTER_TENANT, element);
        }
    }

    public static void validCdiNoSerializable(Element element) {
        if (ProcessorUtils.isNotAnnotationArchScoped(element) && ProcessorUtils.isNotAnnotationCdiScoped(element)) {
            return;
        }
        if (!ElementKind.CLASS.equals((Object)element.getKind())) {
            return;
        }
        TypeMirror serializableType = processingEnvironment.getElementUtils().getTypeElement(Serializable.class.getName()).asType();
        if (processingEnvironment.getTypeUtils().isAssignable(element.asType(), serializableType)) {
            return;
        }
        TypeElement classElement = (TypeElement)element;
        ProcessorUtils.messageError("JARCH ERROR: Classe CDI com escopo sem implementa\u00e7\u00e3o do Serializable encontrado na classe " + classElement.getQualifiedName().toString(), element);
    }

    public static void validAnnotationJArchConfidentialNoImplementISecretData(Element element) {
        TypeMirror secretData = processingEnvironment.getElementUtils().getTypeElement(ISecretData.class.getName()).asType();
        if (processingEnvironment.getTypeUtils().isAssignable(element.asType(), secretData)) {
            return;
        }
        TypeElement classElement = (TypeElement)element;
        ProcessorUtils.messageError("JARCH ERROR: Classe com @JArchConfidential sem implementa\u00e7\u00e3o do ISecretData encontrado na classe " + classElement.getQualifiedName().toString(), element);
    }

    public static void validManagerStateless(Element element) {
        TypeMirror baseRepository = processingEnvironment.getElementUtils().getTypeElement(BaseRepository.class.getName()).asType();
        TypeMirror baseJpaRepository = processingEnvironment.getElementUtils().getTypeElement(BaseJpaRepository.class.getName()).asType();
        if (processingEnvironment.getTypeUtils().directSupertypes(element.asType()).stream().noneMatch(typeMirror -> ((DeclaredType)typeMirror).asElement().equals(((DeclaredType)baseRepository).asElement()) || ((DeclaredType)typeMirror).asElement().equals(((DeclaredType)baseJpaRepository).asElement()))) {
            return;
        }
        ProcessorUtils.messageWarning("JARCH WARNING: O Manager n\u00e3o precisa mais conter anota\u00e7\u00e3o de EJB (@Local ou @Stateless). Remova a anota\u00e7\u00e3o", element);
    }

    public static void validSearchField(Element element, JArchSearchTab searchTab, JArchSearchField searchField) {
        if (searchTab != null && !searchField.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchField dentro de um @JArchSearchTab com atributo classEntity informado indevidamente", element);
        }
        if (searchTab == null && searchField.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchField sem o atributo classEntity informado", element);
        }
        if (FieldType.BINARY.equals((Object)searchField.type())) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchField com atributo type = FieldType.BINARIO n\u00e3o permitido", element);
        }
        if (!searchField.hide() && FieldType.ENTITY.equals((Object)searchField.type())) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchField com atributo type = FieldType.ENTITY n\u00e3o permitido. Use a anota\u00e7\u00e3o @JArchSearchFieldLookup", element);
        }
        if (!searchField.hide() && FieldType.ADDRESS.equals((Object)searchField.type())) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchField com atributo type = FieldType.ADDRESS n\u00e3o permitido. Configure o(s) atributo(s) individualmente", element);
        }
        if (ElementKind.PACKAGE.equals((Object)element.getKind()) && searchField.toString().contains(CLAZZ_ENTITY_EQUAL_VOID) && searchField.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchField classEntity n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchField.field().isEmpty() && searchField.whereJpa().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchField field or whereJpa n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
    }

    public static void validSearchFieldCombobox(Element element, JArchSearchTab searchTab, JArchSearchFieldCombobox searchFieldCombobox) {
        if (searchTab != null && !searchFieldCombobox.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCombobox dentro de um @JArchSearchTab com atributo classEntity informado indevidamente", element);
        }
        if (searchTab == null && searchFieldCombobox.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCombobox sem o atributo classEntity informado", element);
        }
        if (ElementKind.PACKAGE.equals((Object)element.getKind()) && searchFieldCombobox.toString().contains(CLAZZ_ENTITY_EQUAL_VOID) && searchFieldCombobox.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCombobox classEntity n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldCombobox.field().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCombobox field n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldCombobox.fieldItems().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCombobox fieldItems n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldCombobox.fieldShow().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCombobox fieldShow n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
    }

    public static void validSearchFieldComboboxCommandJpa(Element element, JArchSearchTab searchTab, JArchSearchFieldComboboxCommandJpa searchFieldComboboxCommandJpa) {
        if (searchTab != null && !searchFieldComboboxCommandJpa.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldComboboxCommandJpa dentro de um @JArchSearchTab com atributo classEntity informado indevidamente", element);
        }
        if (searchTab == null && searchFieldComboboxCommandJpa.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldComboboxCommandJpa sem o atributo classEntity informado", element);
        }
        if (ElementKind.PACKAGE.equals((Object)element.getKind()) && searchFieldComboboxCommandJpa.toString().contains(CLAZZ_ENTITY_EQUAL_VOID) && searchFieldComboboxCommandJpa.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldComboboxCommandJpa classEntity n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldComboboxCommandJpa.fieldCommandJpa().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldComboboxCommandJpa fieldCommandJpa n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldComboboxCommandJpa.fieldItems().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldComboboxCommandJpa fieldItems n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldComboboxCommandJpa.fieldShow().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldComboboxCommandJpa fieldShow n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
    }

    public static void validSearchFieldCheckbox(Element element, JArchSearchTab searchTab, JArchSearchFieldCheckbox searchFieldCheckbox) {
        if (searchTab != null && !searchFieldCheckbox.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCheckbox dentro de um @JArchSearchTab com atributo classEntity informado indevidamente", element);
        }
        if (searchTab == null && searchFieldCheckbox.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCheckbox sem o atributo classEntity informado", element);
        }
        if (ElementKind.PACKAGE.equals((Object)element.getKind()) && searchFieldCheckbox.toString().contains(CLAZZ_ENTITY_EQUAL_VOID) && searchFieldCheckbox.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCheckbox classEntity n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldCheckbox.field().isEmpty() && searchFieldCheckbox.whereJpa().isEmpty() && !searchFieldCheckbox.hide()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldCheckbox field or whereJpa n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
    }

    public static void validSearchFieldLookup(Element element, JArchSearchTab searchTab, JArchSearchFieldLookup searchFieldLookup) {
        if (searchTab != null && !searchFieldLookup.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldLookup dentro de um @JArchSearchTab com atributo classEntity informado indevidamente", element);
        }
        if (searchTab == null && searchFieldLookup.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldLookup sem o atributo classEntity informado", element);
        }
        if (ElementKind.PACKAGE.equals((Object)element.getKind()) && searchFieldLookup.toString().contains(CLAZZ_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldLookup clazzEntity n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && searchFieldLookup.field().isEmpty() && searchFieldLookup.whereJpa().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchSearchFieldLookup field or whereJpa n\u00e3o informado na declara\u00e7\u00e3o de classe/pacote", element);
        }
    }

    public static void validColumnDataTable(Element element, JArchColumnsDataTable columnsDataTable, JArchColumnDataTable columnDataTable) {
        if (columnsDataTable != null && Arrays.stream(columnsDataTable.columns()).anyMatch(c -> !c.toString().contains(CLASS_ENTITY_EQUAL_VOID))) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchColumnDataTable dentro de um @JArchColumnsDataTable com atributo classEntity informado indevidamente", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && columnsDataTable == null && columnDataTable.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchColumnDataTable classEntity n\u00e3o informado na declara\u00e7\u00e3o de classe", element);
        }
        if ((element.getKind().isClass() || ElementKind.PACKAGE.equals((Object)element.getKind())) && columnDataTable.field().isEmpty()) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchColumnDataTable field n\u00e3o informado na declara\u00e7\u00e3o de classe", element);
        }
        if (ElementKind.PACKAGE.equals((Object)element.getKind()) && columnDataTable.toString().contains(CLAZZ_ENTITY_EQUAL_VOID) && columnDataTable.toString().contains(CLASS_ENTITY_EQUAL_VOID)) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchColumnDataTable clazzEntity n\u00e3o informado na declara\u00e7\u00e3o de classe", element);
        }
        if (FieldType.ADDRESS.equals((Object)columnDataTable.type())) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchColumnDataTable com atributo type = FieldType.ADDRESS n\u00e3o permitido. Configure o(s) atributo(s) individualmente", element);
        }
        if (FieldType.ENTITY.equals((Object)columnDataTable.type())) {
            ProcessorUtils.messageError("JARCH ERROR: @JArchColumnDataTable com atributo type = FieldType.ENTITY n\u00e3o permitido. Configure o(s) atributo(s) individualmente", element);
        }
    }

    public static boolean existsField(TypeElement classeElement, String field) {
        for (Element element : classeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(field) && (!field.contains(".") || !element.getSimpleName().contentEquals(field.substring(0, field.indexOf(".")))) && !element.getSimpleName().contentEquals("get" + field.substring(0, 1).toUpperCase() + field.substring(1))) continue;
            return true;
        }
        if (Object.class.getName().equals(classeElement.toString())) {
            return false;
        }
        return classeElement.getSuperclass() != null && ProcessorUtils.existsField(processingEnvironment.getElementUtils().getTypeElement(classeElement.getSuperclass().toString()), field);
    }

    public static boolean existsFieldType(TypeElement classeElement, String field, List<Class<?>> classList) {
        for (Element element : classeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().contentEquals(field) || !classList.stream().anyMatch(c -> c.getName().equals(ee.asType().toString()))) continue;
            return true;
        }
        return false;
    }

    public static String classTypeField(TypeElement classeElement, String field) {
        for (Element element : classeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().contentEquals(field)) continue;
            return element.asType().toString();
        }
        throw new ProcessorException("Field " + field + " not found in " + String.valueOf(classeElement.getQualifiedName()));
    }

    public static boolean isExistsEntity(Element element, JArchGenerateCrud generateCrud) {
        return ProcessorUtils.isExistsEntity(element, generateCrud.master().name(), generateCrud.nameSubPackage());
    }

    public static boolean isExistsEntity(Element element, String name, String nameSubPackage) {
        String nameMasterSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        File entity = new File(ProcessorUtils.getPathSource(element, nameSubPackage) + nameMasterSemCaracterEspecial + "Entity.java");
        return ProcessorUtils.isFileExistsClientOrWebOrWs(entity);
    }

    public static boolean validExistsFieldSearch(Element element, JArchGenerateCrud generateCrud) {
        if (Arrays.stream(generateCrud.master().fields()).noneMatch(f -> f.search().length > 0)) {
            ProcessorUtils.messageError("JARCH ERROR: Deve haver ao menos um campo como filtro para pesquisa --->>> " + generateCrud.master().name(), element);
            return false;
        }
        return true;
    }

    public static boolean isFileExistsClientOrWebOrWs(File file) {
        for (ModuleType moduleFrom : ModuleType.values()) {
            for (ModuleType moduleTo : ModuleType.values()) {
                File fileExists = new File(file.getAbsolutePath().replace("-" + moduleFrom.name().toLowerCase(), "-" + moduleTo.name().toLowerCase()));
                if (fileExists.exists()) {
                    return true;
                }
                if (!(fileExists = new File(fileExists.getAbsolutePath().replace(File.separator + moduleFrom.name().toLowerCase() + File.separator, File.separator + moduleTo.name().toLowerCase() + File.separator))).exists()) continue;
                return true;
            }
        }
        return false;
    }

    public static void messageAnalyzing(Element element) {
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Analyzing: ", element);
    }

    public static void messageAnalyzing(Class<?> classAnalyzing, Element element) {
    }

    public static void messageAnalyzing(Class<?> classAnalyzing, Class<? extends Annotation> annotation, Element element) {
    }

    private static boolean isNotAnnotationCdiScoped(Element element) {
        return element.getAnnotation(RequestScoped.class) == null && element.getAnnotation(ViewScoped.class) == null && element.getAnnotation(SessionScoped.class) == null && element.getAnnotation(ApplicationScoped.class) == null;
    }

    private static boolean isNotAnnotationArchScoped(Element element) {
        return element.getAnnotation(JArchRequestScoped.class) == null && element.getAnnotation(JArchViewScoped.class) == null && element.getAnnotation(JArchSessionScoped.class) == null && element.getAnnotation(JArchApplicationScoped.class) == null;
    }

    private static String formatMessageErro(String message) {
        return "### JARCH: ANNOTATION PROCESSOR ERROR!!! \n" + message;
    }
}

