/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchConfiguration;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.persistence.SequenceGenerator;

@SupportedAnnotationTypes(value={"javax.persistence.SequenceGenerator"})
public class SequenceGeneratorProcessor
extends AbstractProcessor {
    public static final int MIN_SIZE = 3;
    public static final int POSITION_UNDERLINE = 2;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWith(SequenceGenerator.class).stream().filter(element -> element.getAnnotation(JArchConfiguration.class) == null || !element.getAnnotation(JArchConfiguration.class).ignorePatternsObjetcsDataBase()).filter(element -> element.getEnclosingElement().getAnnotation(JArchConfiguration.class) == null || !element.getEnclosingElement().getAnnotation(JArchConfiguration.class).ignorePatternsObjetcsDataBase()).forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                SequenceGenerator anotacao = element.getAnnotation(SequenceGenerator.class);
                if (anotacao.sequenceName().isEmpty()) {
                    ProcessorUtils.messageError("JARCH ERROR: @SequenceGenerator com sequenceName vazio n\u00e3o permitido. Informar nome da sequence", element);
                }
                if (anotacao.sequenceName().length() < 3 || anotacao.sequenceName().toCharArray()[2] != '_') {
                    ProcessorUtils.messageError("JARCH ERROR: @SequenceGenerator com name fora do padr\u00e3o. Informar nome da sequence da tabela conforme padroniza\u00e7\u00e3o", element);
                }
                if (anotacao.sequenceName().length() > 30) {
                    ProcessorUtils.messageError("JARCH ERROR: @SequenceGenerator com atributo sequenceName superior a 30 caracteres. Informar nome da sequence da tabela com no m\u00e1ximo 30 caracteres", element);
                }
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

