/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchSearchField;
import br.com.jarch.core.annotation.JArchSearchFieldCheckbox;
import br.com.jarch.core.annotation.JArchSearchFieldCombobox;
import br.com.jarch.core.annotation.JArchSearchFieldComboboxCommandJpa;
import br.com.jarch.core.annotation.JArchSearchFieldLookup;
import br.com.jarch.core.annotation.JArchSearchTab;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchSearchTab", "br.com.jarch.core.annotation.JArchSearchTab.List"})
public class SearchTabProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWithAny(Set.of(JArchSearchTab.class, JArchSearchTab.List.class)).stream().forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                this.validSearchTab((Element)element);
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void validSearchTab(Element element) {
        JArchSearchTab[] searchTabs;
        for (JArchSearchTab searchTab : searchTabs = (JArchSearchTab[])element.getAnnotationsByType(JArchSearchTab.class)) {
            for (JArchSearchField jArchSearchField : searchTab.searchFields()) {
                ProcessorUtils.validSearchField(element, searchTab, jArchSearchField);
            }
            for (Annotation annotation : searchTab.searchFieldCheckboxes()) {
                ProcessorUtils.validSearchFieldCheckbox(element, searchTab, (JArchSearchFieldCheckbox)annotation);
            }
            for (Annotation annotation : searchTab.searchFieldComboboxCommandJpas()) {
                ProcessorUtils.validSearchFieldComboboxCommandJpa(element, searchTab, (JArchSearchFieldComboboxCommandJpa)annotation);
            }
            for (Annotation annotation : searchTab.searchFieldComboboxes()) {
                ProcessorUtils.validSearchFieldCombobox(element, searchTab, (JArchSearchFieldCombobox)annotation);
            }
            for (Annotation annotation : searchTab.searchFieldLookups()) {
                ProcessorUtils.validSearchFieldLookup(element, searchTab, (JArchSearchFieldLookup)annotation);
            }
        }
    }
}

