/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.view.ViewScoped;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"javax.faces.bean.ManagedBean"})
public class ManagedBeanProcessor
extends AbstractProcessor {
    public static final String MESSAGE_ERROR = "JARCH ERROR: @ManagedBean do JSF com escopo do CDI encontrado na classe ";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            for (Element element : roundEnv.getElementsAnnotatedWith(ManagedBean.class)) {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                if (!element.getKind().isClass()) continue;
                this.validWithCdi(element);
            }
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void validWithCdi(Element element) {
        TypeElement classeElement = (TypeElement)element;
        if (element.getAnnotation(RequestScoped.class) != null) {
            ProcessorUtils.messageError(MESSAGE_ERROR + classeElement.getQualifiedName().toString(), element);
        }
        if (element.getAnnotation(ViewScoped.class) != null) {
            ProcessorUtils.messageError(MESSAGE_ERROR + classeElement.getQualifiedName().toString(), element);
        }
        if (element.getAnnotation(SessionScoped.class) != null) {
            ProcessorUtils.messageError(MESSAGE_ERROR + classeElement.getQualifiedName().toString(), element);
        }
        if (element.getAnnotation(ApplicationScoped.class) != null) {
            ProcessorUtils.messageError(MESSAGE_ERROR + classeElement.getQualifiedName().toString(), element);
        }
    }
}

