/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchValidExclusives;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchValidExclusives"})
public class ExclusivesProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            for (Element element : roundEnv.getElementsAnnotatedWith(JArchValidExclusives.class)) {
                String[] fields;
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                JArchValidExclusives anotacao = element.getAnnotation(JArchValidExclusives.class);
                if (anotacao.fields().length == 0) {
                    throw new Exception("O atributo fields deve ser preenchido");
                }
                if (anotacao.fields().length == 1) {
                    throw new Exception("Para valida\u00e7\u00e3o de somente um atributo utilize @JArchValidExclusive na declara\u00e7\u00e3o do atributo");
                }
                if (anotacao.ignoreProcessor()) continue;
                TypeElement classeElement = (TypeElement)element;
                for (String field : fields = anotacao.fields()) {
                    this.existsField(element, classeElement, field);
                }
            }
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void existsField(Element elementAtual, TypeElement classeElement, String field) {
        if (!ProcessorUtils.existsField(classeElement, field)) {
            ProcessorUtils.messageError("JARCH ERROR: Atributo " + field + " n\u00e3o localizado na anota\u00e7\u00e3o @JArchValidExclusives da classe " + classeElement.getQualifiedName().toString(), elementAtual);
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return super.getCompletions(element, annotation, member, userText);
    }
}

