/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.AutoIncrementSize;
import br.com.jarch.core.annotation.JArchAutoIncrement;
import br.com.jarch.core.crud.entity.ICrudPessimistEntity;
import br.com.jarch.core.model.ICrudMultiTenantPessimistEntity;
import br.com.jarch.util.LogUtils;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchAutoIncrement", "br.com.jarch.core.annotation.JArchAutoIncrement.List"})
public class AutoIncrementProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWithAny(Set.of(JArchAutoIncrement.class, JArchAutoIncrement.List.class)).forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                this.valid((Element)element);
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void valid(Element element) {
        JArchAutoIncrement[] annotations = (JArchAutoIncrement[])element.getAnnotationsByType(JArchAutoIncrement.class);
        TypeMirror numberType = this.processingEnv.getElementUtils().getTypeElement(Number.class.getName()).asType();
        TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement(String.class.getName()).asType();
        try {
            for (JArchAutoIncrement annotation : annotations) {
                boolean size0;
                if (!this.processingEnv.getTypeUtils().isAssignable(element.getEnclosingElement().asType(), this.processingEnv.getElementUtils().getTypeElement(ICrudPessimistEntity.class.getName()).asType()) && !this.processingEnv.getTypeUtils().isAssignable(element.getEnclosingElement().asType(), this.processingEnv.getElementUtils().getTypeElement(ICrudMultiTenantPessimistEntity.class.getName()).asType())) {
                    ProcessorUtils.messageError("JARCH ERROR: @JArchAutoIncrement somente permitido para classes que implementam ICrudPessimistEntity ou ICrudMultiTenantPessimistEntity", element);
                }
                if ((size0 = annotation.toString().contains(AutoIncrementSize.class.getName())) && !this.processingEnv.getTypeUtils().isAssignable(element.asType(), numberType)) {
                    ProcessorUtils.messageError("JARCH ERROR: @JArchAutoIncrement somente permitido para field com tipo que estenda de Number ", element);
                }
                if (size0 || this.processingEnv.getTypeUtils().isAssignable(element.asType(), stringType)) continue;
                ProcessorUtils.messageError("JARCH ERROR: @JArchAutoIncrement somente permitido para field com tipo String quando atributo size for definido", element);
            }
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
    }
}

