/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import javax.lang.model.element.Element;

public class ServiceCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        ServiceCodeGenerate.generate(element, generateCrud.master().name(), generateCrud.nameSubPackage());
    }

    public static void generate(Element element, String useCase, String nameSubPackage) {
        new ServiceCodeGenerate(element, useCase, nameSubPackage).generate();
    }

    ServiceCodeGenerate(Element element, String useCase, String nameSubPackage) {
        super(element, useCase, nameSubPackage);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.CLIENT;
    }

    @Override
    public CodeType getType() {
        return CodeType.SERVICE;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        this.addPackage(code);
        this.addImports(code);
        this.addBody(code);
        return code.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.annotation.JArchService;");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.crud.service.CrudService;");
        ProcessorUtils.addCode(sbListCode, "import javax.enterprise.inject.spi.CDI;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "@JArchService");
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " extends CrudService<" + this.getNameEntity() + ", " + this.getNameRepository() + "> {");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tpublic static " + this.getName() + " getInstance() {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn CDI.current().select(" + this.getName() + ".class).get();");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

