/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import javax.lang.model.element.Element;

public class ObserverCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new ObserverCodeGenerate(element, generateCrud).generate();
    }

    ObserverCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        super(element, generateCrud);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.CLIENT;
    }

    @Override
    public CodeType getType() {
        return CodeType.OBSERVER;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        this.addPackage(code);
        this.addImports(code);
        this.addBody(code);
        return code.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.annotation.JArchEventLoadCrud;");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.util.JpaUtils;");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "import javax.enterprise.event.Observes;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " {");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tprivate void loadCrud(@Observes @JArchEventLoadCrud " + this.getNameEntity() + " entity) {");
        ProcessorUtils.addCode(sbListCode, "\t\tJpaUtils.initializeCollectionLazy(entity);");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

