/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.IOException;
import javax.lang.model.element.Element;

public final class ListXhtmlCodeGenerate {
    private final Element element;
    private final File fileListXhtml;
    private final File fileListaXhtml;
    private final String nomeSemCaracterEspecial;
    private final String nomeSemCaracterEspecialMinusculo;

    private ListXhtmlCodeGenerate(Element element, String name, String nameSubPackage) {
        this.element = element;
        this.nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(name);
        this.nomeSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(name);
        File folder = new File(ProcessorUtils.getPathPage(element, nameSubPackage));
        if (!folder.exists()) {
            folder.mkdir();
        }
        this.fileListXhtml = new File(ProcessorUtils.getPathPage(element, nameSubPackage) + this.nomeSemCaracterEspecialMinusculo + "List.xhtml");
        this.fileListaXhtml = new File(ProcessorUtils.getPathPage(element, nameSubPackage) + "lista" + this.nomeSemCaracterEspecial + ".xhtml");
    }

    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new ListXhtmlCodeGenerate(element, generateCrud.master().name(), generateCrud.nameSubPackage()).generate(generateCrud.allowInsert(), generateCrud.allowClone(), generateCrud.allowChange(), generateCrud.allowDelete());
    }

    private void generate(boolean allowInsert, boolean allowClone, boolean allowChange, boolean allowDelete) {
        if (ProcessorUtils.isFileExistsClientOrWebOrWs(this.fileListXhtml) || ProcessorUtils.isFileExistsClientOrWebOrWs(this.fileListaXhtml)) {
            return;
        }
        StringBuilder listXhtml = new StringBuilder();
        ProcessorUtils.addCode(listXhtml, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        ProcessorUtils.addCode(listXhtml, "<html xml:lang=\"pt-BR\" xmlns=\"http://www.w3.org/1999/xhtml\"");
        ProcessorUtils.addCode(listXhtml, "\txmlns:h=\"http://xmlns.jcp.org/jsf/html\"");
        ProcessorUtils.addCode(listXhtml, "\txmlns:ui=\"http://xmlns.jcp.org/jsf/facelets\"");
        ProcessorUtils.addCode(listXhtml, "\txmlns:e=\"http://jarch.com.br/ui/extension\">");
        ProcessorUtils.addCode(listXhtml, "\t<h:head>");
        ProcessorUtils.addCode(listXhtml, "\t\t<title/>");
        ProcessorUtils.addCode(listXhtml, "\t</h:head>");
        ProcessorUtils.addCode(listXhtml, "<ui:composition template=\"/paginas/templates/templateList.xhtml\">");
        ProcessorUtils.addCode(listXhtml, "\t<ui:define name=\"panelBodyTemplateLista\">");
        ProcessorUtils.addCode(listXhtml, "\t\t<h:form>");
        ProcessorUtils.addCode(listXhtml, "\t\t\t<e:panelTitle");
        ProcessorUtils.addCode(listXhtml, "\t\t\t\ttitle=\"#{e:bundle('label.lista')} - #{e:bundle('label." + this.nomeSemCaracterEspecialMinusculo + "')}\"");
        ProcessorUtils.addCode(listXhtml, "\t\t\t\tdescription=\"#{e:bundle('label.manter')} #{e:bundle('label." + this.nomeSemCaracterEspecialMinusculo + "')}\"/>");
        ProcessorUtils.addCode(listXhtml, "\t\t\t<e:panelListFilter");
        ProcessorUtils.addCode(listXhtml, "\t\t\t\ttitle=\"#{e:bundle('label.filtro')} - #{e:bundle('label." + this.nomeSemCaracterEspecialMinusculo + "')}\"");
        ProcessorUtils.addCode(listXhtml, "\t\t\t\tactionList=\"#{" + this.nomeSemCaracterEspecialMinusculo + "ListController}\"");
        ProcessorUtils.addCode(listXhtml, "\t\t\t\tupdate=\"@(.list-datatable)\"/>");
        ProcessorUtils.addCode(listXhtml, "\t\t\t<e:panelListDatatable id=\"listEntityDataTable" + this.nomeSemCaracterEspecial + "\"");
        ProcessorUtils.addCode(listXhtml, "\t\t\t\ttitle=\"#{e:bundle('label.lista')} - #{e:bundle('label." + this.nomeSemCaracterEspecialMinusculo + "')}\"");
        ProcessorUtils.addCode(listXhtml, "\t\t\t\tactionList=\"#{" + this.nomeSemCaracterEspecialMinusculo + "ListController}\" " + (allowInsert ? "" : "hideInsert=\"true\" ") + (allowClone ? "" : "hideClone=\"true\" ") + (allowChange ? "" : "hideChange=\"true\" ") + (allowDelete ? "" : "hideDelete=\"true\" ") + "/>");
        ProcessorUtils.addCode(listXhtml, "\t\t</h:form>");
        ProcessorUtils.addCode(listXhtml, "\t</ui:define>");
        ProcessorUtils.addCode(listXhtml, "</ui:composition>");
        ProcessorUtils.addCode(listXhtml, "</html>");
        try {
            FileUtils.save(this.fileListXhtml, listXhtml.toString());
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(this.fileListXhtml.getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }
}

