/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import javax.lang.model.element.Element;

public class JpaConverterCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, String useCase, String nameSubPackage) {
        new JpaConverterCodeGenerate(element, useCase, nameSubPackage).generate();
    }

    JpaConverterCodeGenerate(Element element, String useCase, String nameSubPackage) {
        super(element, useCase, nameSubPackage);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.CLIENT;
    }

    @Override
    public CodeType getType() {
        return CodeType.JPA_CONVERTER;
    }

    @Override
    public String getContent() {
        StringBuilder sbListCode = new StringBuilder();
        this.addPackage(sbListCode);
        this.addImports(sbListCode);
        this.addBody(sbListCode);
        return sbListCode.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import javax.persistence.AttributeConverter;");
        ProcessorUtils.addCode(sbListCode, "import javax.persistence.Converter;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "@Converter(autoApply = true)");
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " implements AttributeConverter<" + this.getNameType() + ", String> {");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\t@Override");
        ProcessorUtils.addCode(sbListCode, "\tpublic String convertToDatabaseColumn(" + this.getNameType() + " valueEnum) {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn valueEnum == null ? null : valueEnum.getAbbreviation();");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\t@Override");
        ProcessorUtils.addCode(sbListCode, "\tpublic " + this.getNameType() + " convertToEntityAttribute(String valueDataBase) {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn valueDataBase == null ? null : " + this.getNameType() + ".abbreviationToEnum(valueDataBase);");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addCode(sbListCode, "}");
    }

    private String getNameType() {
        return this.getName().replace(this.getType().getSuffixName(), "Type");
    }
}

