/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import javax.lang.model.element.Element;

public class EmbeddableAddressCodeGenerate
extends BaseCodeGenerate {
    protected boolean required;

    public static void generate(Element element, JArchGenerateCrud generateCrud, boolean required) {
        EmbeddableAddressCodeGenerate.generate(element, generateCrud.master().name(), generateCrud.nameSubPackage(), required);
    }

    public static void generate(Element element, String useCase, String nameSubPackage, boolean required) {
        EmbeddableAddressCodeGenerate embeddableAddressCodeGenerate = new EmbeddableAddressCodeGenerate(element, useCase, nameSubPackage);
        embeddableAddressCodeGenerate.required = required;
        embeddableAddressCodeGenerate.generate();
    }

    EmbeddableAddressCodeGenerate(Element element, String useCase, String nameSubPackage) {
        super(element, useCase, nameSubPackage);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.CLIENT;
    }

    @Override
    public CodeType getType() {
        return CodeType.EMBEDDABLE;
    }

    @Override
    public String getContent() {
        StringBuilder sbListCode = new StringBuilder();
        this.addPackage(sbListCode);
        this.addImports(sbListCode);
        this.addBody(sbListCode);
        return sbListCode.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import java.io.Serializable;");
        ProcessorUtils.addCode(sbListCode, "import javax.persistence.Column;");
        ProcessorUtils.addCode(sbListCode, "import javax.persistence.Embeddable;");
        ProcessorUtils.addCode(sbListCode, "import javax.validation.constraints.Size;");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.model.IAddress;");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.annotation.JArchValidCep;");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.annotation.JArchValidRequired;");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "@Embeddable");
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " implements IAddress<String>, Serializable {");
        ProcessorUtils.addLineBlank(sbListCode);
        this.addLinesFields(sbListCode);
        this.addLinesGetsSets(sbListCode);
        ProcessorUtils.addCode(sbListCode, "}");
    }

    private void addLinesFields(StringBuilder sbListCode) {
        this.addLineField(sbListCode, "publicPlace", 100, "nm_logradouro");
        this.addLineField(sbListCode, "complement", 50, "ds_complemento");
        this.addLineField(sbListCode, "district", 100, "nm_bairro");
        this.addLineField(sbListCode, "county", 100, "nm_municipio");
        this.addLineField(sbListCode, "state", 2, "sg_uf");
        this.addLineField(sbListCode, "zipCode", 8, "nr_cep");
    }

    private void addLineField(StringBuilder sbListCode, String fieldName, int size, String columnName) {
        ProcessorUtils.addCode(sbListCode, "\t@Column(name = \"" + columnName + "\", length = " + size + ")");
        if (fieldName.equals("zipCode")) {
            ProcessorUtils.addCode(sbListCode, "\t@JArchValidCep");
        } else {
            ProcessorUtils.addCode(sbListCode, "\t@Size(max = " + size + ")");
        }
        if (this.required) {
            ProcessorUtils.addCode(sbListCode, "\t@JArchValidRequired(\"label." + fieldName + "\")");
        }
        ProcessorUtils.addCode(sbListCode, "\tprivate String " + fieldName + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addLinesGetsSets(StringBuilder sbListCode) {
        this.addLinesGetSet(sbListCode, "publicPlace");
        this.addLinesGetSet(sbListCode, "complement");
        this.addLinesGetSet(sbListCode, "district");
        this.addLinesGetSet(sbListCode, "county");
        this.addLinesGetSet(sbListCode, "state");
        this.addLinesGetSet(sbListCode, "zipCode");
    }

    private void addLinesGetSet(StringBuilder sbListCode, String fieldName) {
        String partialNameMethod = fieldName.substring(0, 1).toUpperCase().concat(fieldName.substring(1));
        ProcessorUtils.addCode(sbListCode, "\tpublic String get" + partialNameMethod + "() {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn " + fieldName + ";");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\tpublic void set" + partialNameMethod + "(String " + fieldName + ") {");
        ProcessorUtils.addCode(sbListCode, "\t\tthis." + fieldName + " = " + fieldName + ";");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addLineBlank(sbListCode);
    }
}

