/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL16UTF16
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetAL16UTF16(int n) {
        super(n);
        this.rep = 4;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return !characterSet.isUnicode();
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[n2 >>> 1];
            int n3 = CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, n, cArray, 0, n2, true);
            return new String(cArray, 0, n3);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[n2 >>> 1];
            int n3 = CharacterSet.convertAL16UTF16BytesToJavaChars(byArray, n, cArray, 0, n2, false);
            return new String(cArray, 0, n3);
        }
        catch (SQLException sQLException) {
            CharacterSetAL16UTF16.failUTFConversion();
            return "";
        }
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 4) {
            byArray2 = CharacterSetAL16UTF16.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = CharacterSetAL16UTF16.stringToAL16UTF16Bytes(string);
        }
        return byArray2;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte[] byArray = characterWalker.bytes;
        int n = characterWalker.next;
        int n2 = characterWalker.end;
        if (n + 2 >= n2) {
            CharacterSetAL16UTF16.failUTFConversion();
        }
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        int n3 = by << 8 & 0xFF00 | by2;
        characterWalker.next = n;
        return n3;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        if (n > 65535) {
            CharacterSetAL16UTF16.failUTFConversion();
        } else {
            CharacterSetAL16UTF16.need(characterBuffer, 2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n & 0xFF);
        }
    }
}

