/*
 * Decompiled with CFR 0.152.
 */
package br.com.wesa.utils;

import br.com.jarch.core.model.type.DataBaseType;
import java.sql.Connection;
import java.sql.DriverManager;

public class ConexaoBancoDadosUtils {
    private String stringConexao = "";
    private String arquivoMDB;
    private String sid = "";
    private DataBaseType tipo;
    private String servidor = "";
    private String porta = "";
    private String banco = "";
    private String usuario = "";
    private String senha = "";

    public ConexaoBancoDadosUtils() {
    }

    public ConexaoBancoDadosUtils(DataBaseType tipo, String servidor, String porta, String sid, String banco, String usuario, String senha) {
        this();
        this.tipo = tipo;
        this.servidor = servidor;
        this.porta = porta;
        this.banco = banco;
        this.sid = sid;
        this.usuario = usuario;
        this.senha = senha;
    }

    public ConexaoBancoDadosUtils(String stringConexao) {
        this();
        this.stringConexao = stringConexao;
    }

    public ConexaoBancoDadosUtils(DataBaseType tipo, String arquivoMDB, String usuario, String senha) {
        this.tipo = tipo;
        this.arquivoMDB = arquivoMDB;
        this.usuario = usuario;
        this.senha = senha;
    }

    public DataBaseType getTipo() {
        return this.tipo;
    }

    public void setTipo(DataBaseType tipo) {
        this.tipo = tipo;
    }

    public String getServidor() {
        return this.servidor;
    }

    public void setServidor(String servidor) {
        this.servidor = servidor;
    }

    public String getPorta() {
        return this.porta;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public String getBanco() {
        return this.banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getArquivoMDB() {
        return this.arquivoMDB;
    }

    public void setArquivoMDB(String arquivoMDB) {
        this.arquivoMDB = arquivoMDB;
    }

    public String getStringConexao() {
        return this.stringConexao;
    }

    public void setStringConexao(String stringConexao) {
        this.stringConexao = stringConexao;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public Connection conectar() throws Exception {
        Connection conexao = null;
        if (this.tipo == DataBaseType.ORACLE) {
            Class.forName("oracle.jdbc.OracleDriver");
            Object stringConexao = this.getStringConexao().equals("") ? "jdbc:oracle:thin:@" + this.servidor + ":" + this.porta + ":" + this.sid : this.stringConexao;
            conexao = DriverManager.getConnection((String)stringConexao, this.usuario, this.senha);
        } else if (this.tipo == DataBaseType.SQLSERVER) {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            Object stringConexao = this.getStringConexao().equals("") ? "jdbc:sqlserver://" + this.getServidor() + ";databaseName=" + this.getBanco() + ";user=" + this.getUsuario() + ";password=" + this.getSenha() : this.stringConexao;
            conexao = DriverManager.getConnection((String)stringConexao);
        } else if (this.tipo == DataBaseType.POSTGRESQL) {
            Class.forName("org.postgresql.Driver");
            Object stringConexao = this.getStringConexao().equals("") ? "jdbc:postgresql://" + this.getServidor() + "/" + this.getBanco() : this.stringConexao;
            conexao = DriverManager.getConnection((String)stringConexao, this.getUsuario(), this.getSenha());
        } else {
            throw new Exception("Tipo de Banco Dados nao Suportado");
        }
        if (conexao == null) {
            throw new Exception("Erro na Conexao com o Banco de Dados");
        }
        return conexao;
    }
}

