/*
 * Decompiled with CFR 0.152.
 */
package br.com.wesa.crud.usuario;

import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.model.IUser;
import br.com.wesa.crud.usuario.UsuarioBaseEntity;
import br.com.wesa.crud.usuario.UsuarioBaseRepository;
import java.util.Collection;

public abstract class UsuarioBaseService<E extends UsuarioBaseEntity, D extends UsuarioBaseRepository<E>>
extends CrudService<E, D> {
    public E buscaUmPorLogin(String login) {
        return ((UsuarioBaseRepository)this.getRepository()).pesquisaLogin(login);
    }

    public E buscaUmPorToken(String token) {
        return (E)((UsuarioBaseEntity)((UsuarioBaseRepository)this.getRepository()).searchOneBy("token", token));
    }

    public Collection<E> listaTodosUsuarios() {
        return ((UsuarioBaseRepository)this.getRepository()).searchAll();
    }

    public IUser efetuaLogin(String login, String senha) {
        if (login == null || login.isEmpty()) {
            throw new ValidationException("Login obrigat\u00f3rio");
        }
        if (senha == null || senha.isEmpty()) {
            throw new ValidationException("Senha obrigat\u00f3rio");
        }
        E usuario = this.buscaUmPorLogin(login);
        if (!((UsuarioBaseEntity)usuario).senhaValida(senha)) {
            throw new ValidationException("Senha inv\u00e1lida !");
        }
        return usuario;
    }

    public void validaLoginWebService(String login, String senha) {
        if (((UsuarioBaseRepository)this.getRepository()).searchAllBy("login", login).isEmpty()) {
            throw new ValidationException("Login ou Senha inv\u00e1lido");
        }
        E usuario = this.buscaUmPorLogin(login);
        if (usuario.getSenha() == null) {
            throw new ValidationException("Primeiro Acesso");
        }
        if (!usuario.senhaValida(senha)) {
            throw new ValidationException("Senha inv\u00e1lida");
        }
    }

    public E validaToken(String token) {
        if (((UsuarioBaseRepository)this.getRepository()).searchAllBy("token", token).isEmpty()) {
            throw new ValidationException("Token N\u00c3O localizado");
        }
        return this.buscaUmPorToken(token);
    }

    public void atualizaSenha(String login, String novaSenha) {
        ((UsuarioBaseRepository)this.getRepository()).atualizaSenha(login, novaSenha);
    }

    public void incluiSeNaoExistir(String login) {
        ((UsuarioBaseRepository)this.getRepository()).incluiSeNaoExistir(login);
    }

    public void atualizaUltimoAcesso(E usuario) {
        ((UsuarioBaseRepository)this.getRepository()).atualizaUltimoAcesso(((UsuarioBaseEntity)usuario).getId());
    }
}

