/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.SshUtils;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.OutputStream;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;

class ProgressScpMonitor
implements SftpProgressMonitor {
    private OutputStream outputStreamSsh;
    private final String ip;
    private final LocalTime timeStart;
    private String arquivo;
    private long transferedBytes = 0L;
    private long totalBytes = 0L;
    private int lastPercentPrint = 0;

    public ProgressScpMonitor(String ip, OutputStream outputStreamSsh) {
        this.ip = ip;
        this.timeStart = LocalTime.now();
        this.outputStreamSsh = outputStreamSsh;
    }

    public void init(int op, String arquivo, String dest, long totalBytes) {
        this.totalBytes = totalBytes;
        this.arquivo = arquivo = arquivo.contains(File.separator) ? arquivo.substring(arquivo.lastIndexOf(File.separator) + 1) : arquivo;
        SshUtils.addOutputStream(this.getInfoIpArquivo() + " - Iniciando Transfer\u00eancia", this.outputStreamSsh);
        SshUtils.addOutputStream(this.getInfoIpArquivo() + " - Tamanho Total: " + ProgressScpMonitor.calculaMegaBytes(totalBytes) + " MB", this.outputStreamSsh);
    }

    public boolean count(long bytes) {
        this.transferedBytes += bytes;
        double progress = (double)this.transferedBytes / (double)this.totalBytes * 100.0;
        int percent = (int)progress;
        if (percent > this.lastPercentPrint) {
            SshUtils.addProgress(this.getInfoIpArquivo() + " - Progresso: " + NumberUtils.formatInteger(percent) + "% Transferindo: " + ProgressScpMonitor.calculaMegaBytes(this.transferedBytes) + " MB de " + ProgressScpMonitor.calculaMegaBytes(this.totalBytes) + " MB ", this.outputStreamSsh);
        }
        this.lastPercentPrint = percent;
        return true;
    }

    public void end() {
        double progress = (double)this.transferedBytes / (double)this.totalBytes * 100.0;
        int percent = (int)progress;
        SshUtils.addProgress(this.getInfoIpArquivo() + " - Progresso: " + NumberUtils.formatInteger(percent) + "% Transferindo: " + ProgressScpMonitor.calculaMegaBytes(this.transferedBytes) + " MB de " + ProgressScpMonitor.calculaMegaBytes(this.totalBytes) + " MB", this.outputStreamSsh);
        SshUtils.addOutputStream(this.getInfoIpArquivo() + " - Tempo Total Transfer\u00eancia: " + ChronoUnit.SECONDS.between(this.timeStart, LocalTime.now()) + " Segundo(s)", this.outputStreamSsh);
        if (!this.isTransferSuccess()) {
            String messageErro = this.getInfoIpArquivo() + " - Transfer\u00eancia Conclu\u00edda com ERRO!";
            SshUtils.addOutputStream(messageErro, this.outputStreamSsh);
            throw new RuntimeException(messageErro);
        }
        SshUtils.addOutputStream(this.getInfoIpArquivo() + " - Transfer\u00eancia Conclu\u00edda com Sucesso!", this.outputStreamSsh);
    }

    private boolean isTransferSuccess() {
        return this.transferedBytes == this.totalBytes;
    }

    private String getInfoIpArquivo() {
        return "IP: " + this.ip + " Arquivo: " + this.arquivo;
    }

    private static long calculaMegaBytes(long totalBytes) {
        return totalBytes / 1024L / 1024L;
    }
}

