/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.gca.fx.menu;

import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.gca.fx.logica.LogicType;
import br.com.jarch.gca.fx.logica.LogicaController;
import br.com.jarch.gca.fx.util.BaseFxml;
import br.com.jarch.gca.fx.util.ImagemFx;
import br.com.jarch.util.OperationSystemUtils;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Separator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;

public class MenuPrincipalController
extends BaseFxml {
    @FXML
    private AnchorPane anchorpane;
    @FXML
    private ImageView imageViewSairMinimizar;
    @FXML
    private Label labelWorkingCopy;
    @FXML
    private Label labelUrlGpd;
    @FXML
    private Pagination pagination;
    @FXML
    private ProgressIndicator progressIndicator;
    private Image[] images = new Image[4];

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.progressIndicator.setVisible(false);
        this.imageViewSairMinimizar.setImage(ImagemFx.getInstancia().getImgSairMinimizar());
        try {
            this.labelWorkingCopy.setText(BundleUtils.messageBundle("label.nameComputer") + ": " + OperationSystemUtils.computerName());
            this.labelUrlGpd.setText(BundleUtils.messageBundle("label.systemOperation") + ": " + OperationSystemUtils.getOperationSystem().name());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.configImages();
    }

    public void buttonPesquisaAction(ActionEvent event) {
        this.criaPesquisa();
    }

    public void buttonCrudAction(ActionEvent event) {
        this.criaCrud();
    }

    public void buttonMestreDetalheAction(ActionEvent event) {
        this.criaMestreDetalhe();
    }

    public void sairMinimizarClicked(MouseEvent mouseEvent) {
        this.fecharMinimizar(mouseEvent);
    }

    private void configImages() {
        this.images[0] = new Image(MenuPrincipalController.class.getResource("/logica/crud.png").toExternalForm(), false);
        this.images[1] = new Image(MenuPrincipalController.class.getResource("/logica/mestreDetalhe.png").toExternalForm(), false);
        this.pagination.setPageFactory(pageIndex -> this.createImagePrints((int)pageIndex));
    }

    private VBox createImagePrints(int pageIndex) {
        VBox box = new VBox();
        ImageView imageView = new ImageView(this.images[pageIndex]);
        imageView.setFitWidth(1000.0);
        imageView.setFitHeight(550.0);
        box.setAlignment(Pos.CENTER);
        Button button = new Button();
        if (pageIndex == 0) {
            button.setOnAction(e -> this.criaCrud());
            button.setText(BundleUtils.messageBundle("label.createLogicCrud"));
        } else if (pageIndex == 1) {
            button.setOnAction(e -> this.criaMestreDetalhe());
            button.setText(BundleUtils.messageBundle("label.createLogicMasterDetail"));
        }
        Separator separator = new Separator();
        separator.setPrefHeight(50.0);
        Separator separator2 = new Separator();
        separator2.setPrefHeight(50.0);
        box.getChildren().addAll((Node[])new Node[]{imageView, separator, button, separator2});
        return box;
    }

    private void criaPesquisa() {
        LogicaController.logicaPadrao = LogicType.SEARCH;
        new LogicaController().mostraTela(this.getClass());
    }

    private void criaMestreDetalhe() {
        LogicaController.logicaPadrao = LogicType.MASTER_DETAIL;
        new LogicaController().mostraTela(this.getClass());
    }

    private void criaCrud() {
        LogicaController.logicaPadrao = LogicType.CRUD;
        new LogicaController().mostraTela(this.getClass());
    }
}

