/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.gca.fx.main;

import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.gca.fx.util.EstiloUtils;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;

public class MensagemView {
    private static MensagemView instancia;
    Label lblTitulo;
    Label lblMensagem;
    Button btnSair;
    Pane pane;
    Rectangle rectangle;
    RadialGradient radialGradient;
    AnchorPane anchorpane;

    private MensagemView() {
        this.configTitle();
        this.configMessage();
        this.configButtonExit();
        this.configRetangule();
        this.configPane();
    }

    public static MensagemView getInstancia() {
        if (instancia == null) {
            instancia = new MensagemView();
        }
        return instancia;
    }

    public void showMessageSuccess(AnchorPane anchorpane, String message) {
        this.radialGradient = new RadialGradient(0.0, 0.1, 100.0, 100.0, 20.0, false, CycleMethod.NO_CYCLE, new Stop(0.0, Color.BLACK), new Stop(1.0, Color.BLACK));
        this.rectangle.setFill(this.radialGradient);
        this.btnSair.setStyle(EstiloUtils.botaoOk());
        this.anchorpane = anchorpane;
        this.lblTitulo.setText(BundleUtils.messageBundle("label.aviso"));
        this.lblMensagem.setText(message);
        this.ajustAnchoPane(anchorpane);
    }

    public void showMessageError(AnchorPane anchorpane, String message) {
        this.radialGradient = new RadialGradient(0.0, 0.1, 0.0, 100.0, 20.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.RED), new Stop(1.0, Color.BLACK));
        this.rectangle.setFill(this.radialGradient);
        this.btnSair.setStyle(EstiloUtils.botaoErro());
        this.anchorpane = anchorpane;
        this.lblTitulo.setText(BundleUtils.messageBundle("label.atencao"));
        this.lblMensagem.setText(message);
        this.ajustAnchoPane(anchorpane);
    }

    private void sair() {
        this.anchorpane.getChildren().remove(this.pane);
    }

    private void ajustAnchoPane(AnchorPane anchorpane) {
        if (!anchorpane.getChildren().contains(this.pane)) {
            try {
                anchorpane.getChildren().add(this.pane);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void configRetangule() {
        this.rectangle = new Rectangle();
        this.rectangle.setStrokeWidth(1.0);
        this.rectangle.setWidth(600.0);
        this.rectangle.setHeight(200.0);
    }

    private void configPane() {
        this.pane = new Pane();
        this.pane.setLayoutX(302.0);
        this.pane.setLayoutY(184.0);
        this.pane.setOpacity(1.0);
        this.pane.setPrefSize(600.0, 200.0);
        this.pane.getChildren().addAll((Node[])new Node[]{this.rectangle, this.lblTitulo, this.lblMensagem, this.btnSair});
    }

    private void configButtonExit() {
        InnerShadow innerShadow = new InnerShadow();
        EventHandler<MouseEvent> onMouseEnter = mouseEvent -> {
            this.btnSair.setEffect(null);
            ((Node)mouseEvent.getSource()).setEffect(innerShadow);
        };
        EventHandler<MouseEvent> onMouseExit = mouseEvent -> ((Node)mouseEvent.getSource()).setEffect(null);
        this.btnSair = new Button("OK");
        this.btnSair.setPrefSize(120.0, 20.0);
        this.btnSair.setLayoutX(150.0);
        this.btnSair.setLayoutY(150.0);
        this.btnSair.setOnMouseEntered(onMouseEnter);
        this.btnSair.setOnMouseExited(onMouseExit);
        this.btnSair.setOnMouseClicked(arg0 -> this.sair());
    }

    private void configMessage() {
        Font fntMensagem = new Font("Sanserif", 15.0);
        this.lblMensagem = new Label();
        this.lblMensagem.setFont(fntMensagem);
        this.lblMensagem.setTextFill(Color.WHITE);
        this.lblMensagem.setLayoutX(10.0);
        this.lblMensagem.setLayoutY(15.0);
        this.lblMensagem.setPrefSize(390.0, 150.0);
        this.lblMensagem.setWrapText(true);
    }

    private void configTitle() {
        Font fntTitulo = new Font("Sanserif", 30.0);
        this.lblTitulo = new Label();
        this.lblTitulo.setFont(fntTitulo);
        this.lblTitulo.setTextFill(Color.YELLOW);
        this.lblTitulo.setLayoutX(0.0);
        this.lblTitulo.setLayoutY(0.0);
        this.lblTitulo.setPrefSize(390.0, 50.0);
        this.lblTitulo.setAlignment(Pos.CENTER);
    }
}

