/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.util;

import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.core.util.MessagePropertiesUtils;
import br.com.jarch.util.LogUtils;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;

public final class BeanValidationUtils {
    private static final String VALIDATION_MESSAGES = "ValidationMessages";

    private BeanValidationUtils() {
    }

    public static <T> void applyValidation(@NotNull T objeto, Class<?> ... groupBeanValidation) {
        if (groupBeanValidation == null) {
            return;
        }
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            Set constraintViolations = validator.validate(objeto, (Class[])groupBeanValidation);
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
        }
    }

    public static <T> void applyValidationProperty(T objeto, String property, Class<?> ... groupBeanValidation) {
        if (groupBeanValidation == null) {
            return;
        }
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            Set constraintViolations = validator.validateProperty(objeto, property, (Class[])groupBeanValidation);
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
        }
    }

    public static <T> void validationValue(Class<T> classe, String property, Object value, Class<?> ... groupBeanValidation) {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            Set constraintViolations = validator.validateValue(classe, property, value, (Class[])groupBeanValidation);
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException(constraintViolations);
            }
        }
    }

    public static <T> boolean existsConstraintsValidation(T objeto, Class<?> ... groupBeanValidation) {
        try {
            BeanValidationUtils.applyValidation(objeto, groupBeanValidation);
            return false;
        }
        catch (ConstraintViolationException ve) {
            LogUtils.generate(ve);
            return true;
        }
    }

    public static <T> boolean existsConstraintsValidationProperty(T objeto, String property, Class<?> ... groupBeanValidation) {
        try {
            BeanValidationUtils.applyValidationProperty(objeto, property, groupBeanValidation);
            return false;
        }
        catch (ConstraintViolationException ve) {
            LogUtils.generate(ve);
            return true;
        }
    }

    public static <T> boolean existsConstraintsValidationValue(Class<T> classe, String property, Object value, Class<?> ... groupBeanValidation) {
        try {
            BeanValidationUtils.validationValue(classe, property, value, groupBeanValidation);
            return false;
        }
        catch (ConstraintViolationException ve) {
            LogUtils.generate(ve);
            return true;
        }
    }

    public static boolean existsKeyBundle(String key) {
        String value = BeanValidationUtils.messageBundle(key);
        return !value.contains("???");
    }

    public static String messageBundle(String key) {
        String resultBundle;
        String resultBeanValidation = MessagePropertiesUtils.messageBundle(VALIDATION_MESSAGES, key);
        if (resultBeanValidation.contains("???") && !(resultBundle = BundleUtils.messageBundle(key)).contains("???")) {
            return resultBundle;
        }
        return resultBeanValidation;
    }

    public static String messageBundleParam(String key, String ... parameters) {
        String resultBundle;
        String resultBeanValidation = MessagePropertiesUtils.messageBundleParam(VALIDATION_MESSAGES, key, parameters);
        if (resultBeanValidation.contains("???") && !(resultBundle = BundleUtils.messageBundleParam(key, parameters)).contains("???")) {
            return resultBundle;
        }
        return resultBeanValidation;
    }
}

