/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.rs;

import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.core.model.UserSystem;
import br.com.jarch.core.rs.TokenUtils;
import br.com.jarch.util.LogUtils;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;

public abstract class BaseContainerRequestFilterProvider
implements ContainerRequestFilter {
    public abstract void processFilter(ContainerRequestContext var1);

    public abstract boolean isIgnoreRequiredToken(ContainerRequestContext var1);

    public void validation(ContainerRequestContext containerRequestContext) {
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        String multiTenantId = containerRequestContext.getHeaderString("multiTenantId");
        String idMultiTenant = containerRequestContext.getHeaderString("idMultiTenant");
        if (multiTenantId != null && !multiTenantId.isBlank()) {
            MultiTenant.getInstance().set(Long.parseLong(multiTenantId));
        } else if (idMultiTenant != null && !idMultiTenant.isBlank()) {
            MultiTenant.getInstance().set(Long.parseLong(idMultiTenant));
        }
        UserInformation.getInstance().set(UserSystem.get());
        this.processFilter(containerRequestContext);
        try {
            this.validation(containerRequestContext);
            if (this.isIgnoreRequiredToken(containerRequestContext)) {
                return;
            }
            TokenUtils.validation(this.getSecret(), containerRequestContext);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ex.getMessage()).build());
        }
    }

    public abstract String getSecret();
}

