/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.report;

import br.com.jarch.core.report.IReportBase;
import br.com.jarch.core.type.FileType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;

public abstract class ReportBase
implements IReportBase {
    private final Map<String, Object> parametros = new HashMap<String, Object>();

    @Override
    public void addParam(String chave, Object conteudo) {
        this.parametros.put(chave, conteudo);
    }

    @Override
    public Object getParam(String chave) {
        return this.parametros.get(chave);
    }

    @Override
    public void removeParam(String chave) {
        this.parametros.remove(chave);
    }

    @Override
    public void clearParam() {
        this.parametros.clear();
    }

    @Override
    public InputStream processReport() {
        try {
            this.beforeProcess();
            JasperPrint jasperPrint = this.processaDadosJasper();
            if (jasperPrint == null) {
                throw new RuntimeException(BundleUtils.messageBundle("message.naoExisteDadosImpressao"));
            }
            if (this.typeReport() == FileType.PDF) {
                File arquivoPdfGeracao = File.createTempFile(this.fileName(), ".pdf");
                FileInputStream pdfStream = new FileInputStream(arquivoPdfGeracao.getAbsolutePath());
                JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)arquivoPdfGeracao.getAbsolutePath());
                return pdfStream;
            }
            if (this.typeReport() == FileType.EXCEL) {
                File arquivoPdfGeracao = File.createTempFile(this.fileName(), ".xlsx");
                FileOutputStream outputStream = new FileOutputStream(arquivoPdfGeracao.getAbsolutePath());
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
                configuration.setOnePagePerSheet(Boolean.valueOf(true));
                configuration.setDetectCellType(Boolean.valueOf(true));
                configuration.setCollapseRowSpan(Boolean.valueOf(false));
                exporter.setConfiguration((ReportExportConfiguration)configuration);
                exporter.exportReport();
                return new FileInputStream(arquivoPdfGeracao.getAbsolutePath());
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public File generatePdf() {
        try {
            JasperPrint impressoraJasper = this.processaDadosJasper();
            File arquivoPdfGeracao = File.createTempFile(this.fileName(), ".pdf");
            JasperExportManager.exportReportToPdfFile((JasperPrint)impressoraJasper, (String)arquivoPdfGeracao.getAbsolutePath());
            return arquivoPdfGeracao;
        }
        catch (Exception e) {
            LogUtils.generate(e);
            return null;
        }
    }

    private JasperPrint processaDadosJasper() {
        try {
            Collection<?> listaDados = this.getData();
            if (listaDados.isEmpty()) {
                return null;
            }
            JRBeanCollectionDataSource dados = new JRBeanCollectionDataSource(listaDados);
            if (this.streamJrxml() != null) {
                JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)this.streamJrxml());
                return JasperFillManager.fillReport((JasperReport)jasperReport, this.parametros, (JRDataSource)dados);
            }
            if (this.streamJasper() != null) {
                return JasperFillManager.fillReport((InputStream)this.streamJasper(), this.parametros, (JRDataSource)dados);
            }
            if (this.fileNameJrxml() != null) {
                JasperReport jasperReport = JasperCompileManager.compileReport((String)this.fileNameJrxml());
                return JasperFillManager.fillReport((JasperReport)jasperReport, this.parametros, (JRDataSource)dados);
            }
            return JasperFillManager.fillReport((String)this.fileNameJasper(), this.parametros, (JRDataSource)dados);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

