/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.model;

import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.model.IUser;
import br.com.jarch.core.model.UserSystem;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.CDI;

@Vetoed
public class UserInformation
implements Serializable {
    private IUser user;

    public <T extends IUser> T get() {
        return (T)this.user;
    }

    public <T> T get(Class<T> clazz) {
        return clazz.cast(this.user);
    }

    public <T extends IUser> void set(T user) {
        this.user = user;
        UserInformation.setIdUserThread(user);
        GlobalInformation.getInstance().set("jarch.userInformation", this);
    }

    private static <T extends IUser> void setIdUserThread(T user) {
        String nameThreadOld = Thread.currentThread().getName();
        Object nameThreadNew = Thread.currentThread().getName();
        if (((String)nameThreadNew).contains("_IdUser=")) {
            nameThreadNew = ((String)nameThreadNew).replaceAll("_IdUser=-?\\d+_", "");
        }
        if (user != null && user.getId() != null) {
            nameThreadNew = (String)nameThreadNew + "_IdUser=" + user.getId() + "_";
        }
        GlobalInformation.getInstance().moveAllToNewKey(nameThreadOld, (String)nameThreadNew);
        Thread.currentThread().setName((String)nameThreadNew);
    }

    public static Long getIdUserThread() {
        String nameThread = Thread.currentThread().getName();
        String regex = "IdUser=(-?\\d+)_";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(nameThread);
        if (!matcher.find()) {
            throw new ValidationException("N\u00e3o localizado o ID do usu\u00e1rio");
        }
        String idUser = matcher.group(1);
        return Long.parseLong(idUser);
    }

    public void setUserSystemIfNotExists() {
        if (this.isExists()) {
            return;
        }
        this.setUserSystem();
    }

    public void setUserSystem() {
        this.user = UserSystem.get();
        UserInformation.setIdUserThread(this.user);
    }

    public void setUserSystem(Long id) {
        this.user = UserSystem.get();
        this.user.setId(id);
        UserInformation.setIdUserThread(this.user);
    }

    public boolean isExecutionSystemTest() {
        Boolean retorno = (Boolean)GlobalInformation.getInstance().get("jarch.executionSystemTest");
        return retorno != null && retorno != false;
    }

    public void remove() {
        this.user = null;
    }

    public boolean isExists() {
        return this.user != null;
    }

    public boolean isNotExists() {
        return this.user == null;
    }

    public boolean isSystem() {
        return this.isExists() && this.get().getClass() == UserSystem.class;
    }

    public boolean isNotSystem() {
        return !this.isSystem();
    }

    public boolean isNotExistsOrSystem() {
        return !this.isExists() || this.isSystem();
    }

    public void activeExecutionSystemTest() {
        GlobalInformation.getInstance().set("jarch.executionSystemTest", Boolean.valueOf(true));
    }

    public void deactiveExecutionSystemTest() {
        GlobalInformation.getInstance().set("jarch.executionSystemTest", Boolean.valueOf(false));
    }

    public static UserInformation getInstance() {
        return (UserInformation)CDI.current().select(UserInformation.class, new Annotation[0]).get();
    }
}

