/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.form;

import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.form.SearchFieldForm;
import br.com.jarch.core.form.XhtmlFieldForm;
import br.com.jarch.core.type.FieldType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FieldForm {
    private final String atributo;
    private final String campoTabela;
    private final String descricao;
    private final FieldType tipo;
    private final List<SearchFieldForm> searchs = new ArrayList<SearchFieldForm>();
    private final List<XhtmlFieldForm> xhtmls = new ArrayList<XhtmlFieldForm>();
    private final boolean obrigatorio;
    private final boolean exclusive;
    private final boolean codeLookup;
    private final boolean descriptionLookup;
    private int order;

    public FieldForm(String atributo, String campoTabela, String descricao, FieldType tipo, JArchGenerateCrud.Search[] search, JArchGenerateCrud.Xhtml[] xhtml, boolean obrigatorio, boolean exclusive, boolean codeLookup, boolean descriptionLookup) {
        this.atributo = atributo;
        this.campoTabela = campoTabela;
        this.descricao = descricao;
        this.tipo = tipo;
        this.searchs.addAll(Arrays.stream(search).map(l -> new SearchFieldForm(l.row(), l.column(), l.span())).collect(Collectors.toList()));
        this.xhtmls.addAll(Arrays.stream(xhtml).map(l -> new XhtmlFieldForm(l.rowDataXhtml(), l.columnDataXhtml(), l.showDataTableList(), l.width())).collect(Collectors.toList()));
        this.obrigatorio = obrigatorio;
        this.exclusive = exclusive;
        this.codeLookup = codeLookup;
        this.descriptionLookup = descriptionLookup;
    }

    public FieldForm(String atributo, String campoTabela, String descricao, FieldType tipo, List<SearchFieldForm> searchs, List<XhtmlFieldForm> xhtmls, boolean obrigatorio, boolean exclusive, boolean codeLookup, boolean descriptionLookup) {
        this.atributo = atributo;
        this.campoTabela = campoTabela;
        this.descricao = descricao;
        this.tipo = tipo;
        this.searchs.addAll(searchs);
        this.xhtmls.addAll(xhtmls);
        this.obrigatorio = obrigatorio;
        this.exclusive = exclusive;
        this.codeLookup = codeLookup;
        this.descriptionLookup = descriptionLookup;
    }

    public String getAtributo() {
        return this.atributo;
    }

    public String getCampoTabela() {
        return this.campoTabela;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public FieldType getTipo() {
        return this.tipo;
    }

    public List<SearchFieldForm> getSearch() {
        return this.searchs;
    }

    public List<XhtmlFieldForm> getXhtml() {
        return this.xhtmls;
    }

    public boolean isObrigatorio() {
        return this.obrigatorio;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isCodeLookup() {
        return this.codeLookup;
    }

    public boolean isDescriptionLookup() {
        return this.descriptionLookup;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getAtributoPrimeiroLetraMaiusculo() {
        return this.getAtributo().substring(0, 1).toUpperCase() + this.getAtributo().substring(1);
    }

    public String getBundleCodigoJava() {
        return "label." + this.getAtributo();
    }

    public String getGenerateId(String nameMaster, String dataDetail) {
        return this.tipo.getGenerateId(nameMaster, dataDetail, this.atributo);
    }

    public String getTagXhtml(boolean master, String nameAction, String nameMaster, String dataDetail, String entity, String tabsDentro) {
        return this.tipo.getTagXhtml(master, nameAction, nameMaster, dataDetail, entity, this.atributo, this.obrigatorio, tabsDentro);
    }

    public String getBundleJsf() {
        return FieldType.getBundleJsf(this.atributo);
    }
}

