/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.servlet;

import br.com.jarch.core.annotation.JArchEventLogoutAfter;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.util.LogUtils;
import java.io.IOException;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(urlPatterns={"/LogoutServlet"})
public class LogoutServlet
extends HttpServlet {
    @Inject
    @JArchEventLogoutAfter
    private Event<HttpServletRequest> eventLogoutAfter;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        long tenantId = 0L;
        MultiTenant multiTenant = MultiTenant.getInstance();
        if (multiTenant != null) {
            tenantId = multiTenant.get();
        }
        this.eventLogoutAfter.fire(request);
        GlobalInformation.getInstance().clear();
        request.getSession().invalidate();
        try {
            response.sendRedirect("paginas/login/login.jsf?multiTenantId=" + tenantId);
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }
}

