/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.search;

import br.com.jarch.core.annotation.JArchSearchFieldCheckbox;
import br.com.jarch.core.annotation.JArchSearchFieldCombobox;
import br.com.jarch.core.annotation.JArchSearchFieldComboboxCommandJpa;
import br.com.jarch.core.annotation.JArchSearchWhereJpa;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.crud.search.BaseFieldSearchFactory;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.core.util.JpqlUtils;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.ReflectionUtils;
import br.com.jarch.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.xml.bind.annotation.XmlTransient;

public class FieldSearch
extends BaseFieldSearchFactory {
    private String id;
    private int tabOrder;
    private String tabName = "label.main";
    private Integer row;
    private Integer column;
    private Integer span;
    private FieldType type;
    private ConditionSearchType condition;
    private String attribute;
    private String description;
    private boolean required;
    private Object value;
    private String mask;
    private Class<?> annotation;
    private String whereJpa;
    private Converter<?> converterJsf;
    private Validator<?> validatorJsf;
    private boolean hideCode;
    private boolean visible = true;
    private boolean disabled;
    private boolean showCondition;
    private boolean disabledCondition;
    private String fieldShowCombobox;
    private String fieldValueCombobox;
    private Collection<?> itemsCombobox;
    private Class<?> classAttribute;
    private boolean active = true;
    private String toolTip;
    private String labelFirstItem;
    private boolean visibleFirstItem = true;
    private final Map<String, Object> valueWhereJpa;
    private boolean clearValueByButton = true;
    private Class<?> classEntityLookup;
    private Class<? extends Enum> classEnum;
    private boolean zeroLeft;
    private int quantityZeroLeft;
    private String others;
    private String[] parametersBind;
    private Class<?> classFilterSelectController = Void.TYPE;

    private FieldSearch() {
        this.labelFirstItem = BundleUtils.messageBundle("label.todos");
        this.valueWhereJpa = new HashMap<String, Object>();
        this.parametersBind = new String[0];
    }

    public static FieldSearch createInstance() {
        return new FieldSearch();
    }

    public Class<?> getAnnotation() {
        return this.annotation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMask() {
        return this.mask;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getAttributeJpql(Class<?> classEntity) {
        String prefixo = this.attribute.equals(JpqlUtils.aliasEntity(classEntity)) ? "" : JpqlUtils.aliasEntity(classEntity) + ".";
        String result = prefixo + this.attribute;
        if (this.isDynamicColumn()) {
            if (this.isNumber()) {
                if (JpqlUtils.isOracle()) {
                    result = "to_number(replace(replace(" + result + ", '.', ''), ',', '.'))";
                } else if (JpqlUtils.isPostgreSql()) {
                    result = "to_number(replace(replace(" + result + ", '.', ''), ',', '.'), '999999999999.99')";
                }
            } else if (this.isLocalDate()) {
                result = "to_date(" + result + ", 'DD/MM/YYYY')";
            } else if (this.isLocalDateTime()) {
                if (JpqlUtils.isOracle()) {
                    result = "to_date(" + result + ", 'DD/MM/YYYY HH24:MI')";
                } else if (JpqlUtils.isPostgreSql()) {
                    result = "to_timestamp(" + result + ", 'DD/MM/YYYY HH24:MI')";
                }
            }
        }
        return result;
    }

    public String getWhereJpa() {
        return this.whereJpa == null ? "" : this.whereJpa;
    }

    public String getDescription() {
        return this.description;
    }

    public ConditionSearchType getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionSearchType condition) {
        this.condition = condition;
    }

    public Converter<?> getConverterJsf() {
        return this.converterJsf;
    }

    public Validator<?> getValidatorJsf() {
        return this.validatorJsf;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Object getValue() {
        if (this.value != null && this.isNumber()) {
            return ReflectionUtils.createInstance(this.classAttribute, this.value.toString());
        }
        return this.value;
    }

    public void setValue(Object value) {
        String valueOnlyNumber;
        int sizeRepeat;
        this.value = value;
        if (value != null && this.zeroLeft && (sizeRepeat = this.quantityZeroLeft - (valueOnlyNumber = NumberUtils.onlyNumber(value.toString())).length()) > 0) {
            this.value = "0".repeat(sizeRepeat) + String.valueOf(value);
        }
    }

    public boolean isHideCode() {
        return this.hideCode;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isShowCondition() {
        return this.showCondition;
    }

    public boolean isDisabledCondition() {
        return this.disabledCondition;
    }

    public Integer getRow() {
        return this.row;
    }

    public Integer getColumn() {
        return this.column;
    }

    public Integer getSpan() {
        return this.span;
    }

    public String getTabName() {
        return this.tabName;
    }

    public int getTabOrder() {
        return this.tabOrder;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getLabelFirstItem() {
        return this.labelFirstItem;
    }

    public boolean isVisibleFirstItem() {
        return this.visibleFirstItem;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public String getOthers() {
        return this.others;
    }

    public String[] getParametersBind() {
        return this.parametersBind;
    }

    public Class<?> getClassEntityLookup() {
        return this.classEntityLookup;
    }

    public int getQuantityZeroLeft() {
        return this.quantityZeroLeft;
    }

    public Class<?> getClassFilterSelectController() {
        return this.classFilterSelectController;
    }

    @XmlTransient
    @JsonIgnore
    public String getParameterJpql() {
        return this.id.replace(".", "_");
    }

    public Class<?> getClassAttribute() {
        return this.classAttribute;
    }

    public Class<? extends Enum> getClassEnum() {
        return this.classEnum;
    }

    public Map<String, Object> getValueWhereJpa() {
        return this.valueWhereJpa;
    }

    public boolean isClearValueByButton() {
        return this.clearValueByButton;
    }

    public boolean isZeroLeft() {
        return this.zeroLeft;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCep() {
        return this.type != null && this.type.equals((Object)FieldType.CEP);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCnpj() {
        return this.type != null && this.type.equals((Object)FieldType.CNPJ);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCnpjBase() {
        return this.type != null && this.type.equals((Object)FieldType.CNPJ_BASE);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCpfCnpj() {
        return this.type != null && this.type.equals((Object)FieldType.CPFCNPJ);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCode() {
        return this.type != null && this.type.equals((Object)FieldType.CODE);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isMonthYear() {
        return this.type != null && this.type.equals((Object)FieldType.MONTH_YEAR) && YearMonth.class.isAssignableFrom(this.classAttribute);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCpf() {
        return this.type != null && this.type.equals((Object)FieldType.CPF);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isDate() {
        return FieldType.DATE.equals((Object)this.type) && Date.class.isAssignableFrom(this.classAttribute);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isDateTime() {
        return FieldType.DATE_TIME.equals((Object)this.type) && Date.class.isAssignableFrom(this.classAttribute);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isLocalDate() {
        return !this.isDate() && FieldType.DATE.equals((Object)this.type);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isLocalDateTime() {
        return !this.isDateTime() && FieldType.DATE_TIME.equals((Object)this.type);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isDescriptionNameGeneric() {
        return this.type != null && (this.type.equals((Object)FieldType.DESCRIPTION) || this.type.equals((Object)FieldType.GENERIC) || this.type.equals((Object)FieldType.NAME));
    }

    @XmlTransient
    @JsonIgnore
    public boolean isDescriptionNameGenericSmall() {
        return this.type != null && (this.type.equals((Object)FieldType.SHORT_DESCRIPTION) || this.type.equals((Object)FieldType.SHORT_NAME));
    }

    @XmlTransient
    @JsonIgnore
    public boolean isPassword() {
        return this.type != null && this.type.equals((Object)FieldType.PASSWORD);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isEmail() {
        return this.type != null && this.type.equals((Object)FieldType.EMAIL);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isHour() {
        return this.type.equals((Object)FieldType.HOUR);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isIm() {
        return this.type != null && this.type.equals((Object)FieldType.IM);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isMemoRich() {
        return this.type != null && this.type.equals((Object)FieldType.MEMO_RICH);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isMemoSimple() {
        return this.type != null && this.type.equals((Object)FieldType.MEMO_SIMPLE);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isNumberInteger() {
        return this.type != null && this.type.isInteger();
    }

    @XmlTransient
    @JsonIgnore
    public boolean isNumberLong() {
        return this.type != null && this.type.isLong();
    }

    @XmlTransient
    @JsonIgnore
    public boolean isRate() {
        return this.type != null && this.type.equals((Object)FieldType.RATE);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isNumberDecimals() {
        return this.type != null && this.type.isDecimal();
    }

    @XmlTransient
    @JsonIgnore
    public boolean isNumber() {
        return this.isNumberInteger() || this.isNumberDecimals();
    }

    @XmlTransient
    @JsonIgnore
    public boolean isRg() {
        return this.type != null && this.type.equals((Object)FieldType.RG);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCombobox() {
        return this.annotation == JArchSearchFieldCombobox.class;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isComboboxCommandJpa() {
        return this.annotation == JArchSearchFieldComboboxCommandJpa.class;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isTelephone() {
        return this.type.equals((Object)FieldType.TELEPHONE) || this.type.equals((Object)FieldType.CELLPHONE);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCheckbox() {
        return this.annotation == JArchSearchFieldCheckbox.class;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isBoolean() {
        return FieldType.BOOLEAN.equals((Object)this.type);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isChips() {
        return FieldType.CHIPS.equals((Object)this.type);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isBooleanWithWhereJpa() {
        return FieldType.BOOLEAN.equals((Object)this.type) && this.whereJpa != null && !this.whereJpa.isBlank();
    }

    @XmlTransient
    @JsonIgnore
    public boolean isEntity() {
        return this.type != null && this.type.equals((Object)FieldType.ENTITY);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isMoney() {
        return FieldType.MONEY.equals((Object)this.type);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isDynamicColumn() {
        return this.attribute != null && this.attribute.contains("dynamicColumn");
    }

    public String getFieldShowCombobox() {
        return this.fieldShowCombobox;
    }

    public String getFieldValueCombobox() {
        return this.fieldValueCombobox;
    }

    public Collection<?> getItemsCombobox() {
        return this.itemsCombobox;
    }

    public FieldSearch annotation(Class<?> annotation) {
        this.annotation = annotation;
        return this;
    }

    public FieldSearch id(String id) {
        this.id = id;
        return this;
    }

    public FieldSearch mask(String mask) {
        this.mask = mask;
        return this;
    }

    public FieldSearch classAttribute(Class<?> classAttribute) {
        this.classAttribute = classAttribute;
        return this;
    }

    public FieldSearch type(FieldType type) {
        this.type = type;
        return this;
    }

    public FieldSearch attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public FieldSearch condition(ConditionSearchType condicao) {
        this.condition = condicao;
        return this;
    }

    public FieldSearch description(String description) {
        this.description = description;
        return this;
    }

    public FieldSearch required() {
        this.required = true;
        return this;
    }

    public FieldSearch noRequired() {
        this.required = false;
        return this;
    }

    public FieldSearch required(boolean required) {
        this.required = required;
        return this;
    }

    public FieldSearch value(Object value) {
        this.value = value;
        return this;
    }

    public FieldSearch clearValueByButton(boolean clearValueByButton) {
        this.clearValueByButton = clearValueByButton;
        return this;
    }

    public FieldSearch active(boolean active) {
        this.active = active;
        return this;
    }

    public FieldSearch active() {
        this.active = true;
        return this;
    }

    public FieldSearch inactive() {
        this.active = false;
        return this;
    }

    public FieldSearch hideCode() {
        this.hideCode = true;
        return this;
    }

    public FieldSearch hide() {
        this.visible = false;
        return this;
    }

    public FieldSearch hide(boolean hide) {
        this.visible = !hide;
        return this;
    }

    public FieldSearch enabled() {
        this.disabled = false;
        return this;
    }

    public FieldSearch disabled() {
        this.disabled = true;
        return this;
    }

    public FieldSearch disabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public FieldSearch visible() {
        this.visible = true;
        return this;
    }

    public FieldSearch visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public FieldSearch visibleCondition(boolean showCondition) {
        this.showCondition = showCondition;
        return this;
    }

    public FieldSearch disabledCondition(boolean disabledCondition) {
        this.disabledCondition = disabledCondition;
        return this;
    }

    public FieldSearch row(Integer row) {
        this.row = row;
        return this;
    }

    public FieldSearch column(Integer column) {
        this.column = column;
        return this;
    }

    public FieldSearch where(String whereJpa) {
        this.whereJpa = whereJpa;
        return this;
    }

    public FieldSearch span(Integer span) {
        this.span = span;
        return this;
    }

    public FieldSearch tabName(String tabName) {
        this.tabName = tabName;
        return this;
    }

    public FieldSearch tabOrder(int tabOrder) {
        this.tabOrder = tabOrder;
        return this;
    }

    public FieldSearch tooltip(String toolTip) {
        this.toolTip = toolTip;
        return this;
    }

    public FieldSearch labelFirstItem(String labelFirstItem) {
        this.labelFirstItem = labelFirstItem;
        return this;
    }

    public FieldSearch visibleFirstItem(boolean visibleFirstItem) {
        this.visibleFirstItem = visibleFirstItem;
        return this;
    }

    public FieldSearch itemsCombobox(Collection<?> itemsCombobox) {
        this.itemsCombobox = itemsCombobox;
        return this;
    }

    public FieldSearch fieldShowCombobox(String fieldShowCombobox) {
        this.fieldShowCombobox = fieldShowCombobox;
        return this;
    }

    public FieldSearch fieldValueCombobox(String fieldValueCombobox) {
        this.fieldValueCombobox = fieldValueCombobox;
        return this;
    }

    public FieldSearch clearValueByButton() {
        this.clearValueByButton = true;
        return this;
    }

    public FieldSearch noClearValueByButton() {
        this.clearValueByButton = false;
        return this;
    }

    public FieldSearch classEntityLookup(Class<?> classEntityLookup) {
        this.classEntityLookup = classEntityLookup;
        return this;
    }

    public FieldSearch classFilterSelectController(Class<?> classFilterSelectController) {
        this.classFilterSelectController = classFilterSelectController;
        return this;
    }

    public FieldSearch classEnum(Class<? extends Enum> classEnum) {
        this.classEnum = classEnum;
        return this;
    }

    public FieldSearch zeroLeft(boolean zeroLeft) {
        this.zeroLeft = zeroLeft;
        return this;
    }

    public FieldSearch zeroLeft() {
        this.zeroLeft = true;
        return this;
    }

    public FieldSearch quantityZeroLeft(int quantityZeroLeft) {
        this.quantityZeroLeft = quantityZeroLeft;
        return this;
    }

    public FieldSearch others(String others) {
        this.others = others;
        return this;
    }

    public FieldSearch converterJsf(Class<? extends Converter> clazzConverter) {
        try {
            if (!clazzConverter.equals(Converter.class)) {
                this.converterJsf = clazzConverter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public FieldSearch validatorJsf(Class<? extends Validator> clazzValidator) {
        try {
            if (!clazzValidator.equals(Validator.class)) {
                this.validatorJsf = clazzValidator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public FieldSearch parametersBind(String[] parametersBind) {
        this.parametersBind = parametersBind;
        return this;
    }

    public FieldSearch hideCode(boolean hideCode) {
        this.hideCode = hideCode;
        return this;
    }

    public void addParamValueWhereJpa(String nameParam, Object valueParam) {
        this.valueWhereJpa.put(nameParam, valueParam);
    }

    public void removeParamValueWhereJpa(String nameParam) {
        this.valueWhereJpa.remove(nameParam);
    }

    @XmlTransient
    @JsonIgnore
    public String getFilterSelectActionStr() {
        Class<?> classControllerUsed = this.classFilterSelectController == Void.TYPE ? this.classEntityLookup : this.classFilterSelectController;
        return "#{" + classControllerUsed.getSimpleName().substring(0, 1).toLowerCase().concat(classControllerUsed.getSimpleName().substring(1).replace("Entity", "FilterSelectAction")) + "}";
    }

    @XmlTransient
    @JsonIgnore
    public String getFilterSelectControllerStr() {
        Class<?> classControllerUsed = this.classFilterSelectController == Void.TYPE ? this.classEntityLookup : this.classFilterSelectController;
        return "#{" + classControllerUsed.getSimpleName().substring(0, 1).toLowerCase().concat(classControllerUsed.getSimpleName().substring(1).replace("Entity", "FilterSelectController")) + "}";
    }

    @XmlTransient
    @JsonIgnore
    public String getFormattedValue() {
        if (this.value == null) {
            return "";
        }
        if (this.type != null) {
            return this.type.format(this.value);
        }
        if (!Map.class.isAssignableFrom(this.value.getClass())) {
            return this.value.toString();
        }
        return this.collectFromValueMap();
    }

    private String collectFromValueMap() {
        return ((Map)this.value).entrySet().stream().map(this::collectFromLineMap).collect(Collectors.joining(", "));
    }

    private String collectFromLineMap(Map.Entry<String, Object> mapValue) {
        if (Collection.class.isAssignableFrom(mapValue.getValue().getClass())) {
            return this.collectValueFormattedFromCollection((Collection)mapValue.getValue());
        }
        return this.collectionValueFormatted(mapValue.getValue());
    }

    private String collectValueFormattedFromCollection(Collection<Object> entry) {
        return "(" + entry.stream().map(this::collectionValueFormatted).collect(Collectors.joining(", ")) + ")";
    }

    private String collectionValueFormatted(Object valueFormatted) {
        if (!valueFormatted.getClass().isEnum()) {
            return "";
        }
        Optional<Object> valueDescription = ReflectionUtils.getOptionalValueByName(valueFormatted, "descricao");
        if (valueDescription.isPresent()) {
            return valueDescription.get().toString();
        }
        valueDescription = ReflectionUtils.getOptionalValueByName(valueFormatted, "description");
        if (valueDescription.isPresent()) {
            return valueDescription.get().toString();
        }
        return "";
    }

    @XmlTransient
    @JsonIgnore
    public boolean isAddedValue() {
        if (this.value == null) {
            return false;
        }
        if (this.isComboboxCommandJpa()) {
            return !this.value.toString().isEmpty();
        }
        if (this.isFieldWhereJpaFill()) {
            return this.condition != null && this.getQuantityValue() > 0;
        }
        if (this.isCheckbox()) {
            return (Boolean)this.value;
        }
        if (this.isSearchWhereJpa()) {
            return !Map.class.isAssignableFrom(this.value.getClass()) || ((Map)this.value).size() > 0;
        }
        return this.condition != null && this.value != null;
    }

    private boolean isSearchWhereJpa() {
        return this.annotation == JArchSearchWhereJpa.class;
    }

    private boolean isFieldWhereJpaFill() {
        return this.whereJpa == null || this.whereJpa.isEmpty();
    }

    @XmlTransient
    @JsonIgnore
    public int getQuantityValue() {
        if (this.isCollection()) {
            return ((Collection)this.value).size();
        }
        if (this.value != null && this.isNumber() && new BigDecimal(this.value.toString()).doubleValue() == 0.0) {
            return 0;
        }
        if (this.value != null && !this.value.toString().isBlank()) {
            return 1;
        }
        return 0;
    }

    @XmlTransient
    @JsonIgnore
    public Object getValueReadyFilter() {
        if (!this.isAddedValue() || this.isCollection() || this.isMonthYear()) {
            return this.value;
        }
        if (this.isDate()) {
            return this.configValueDate();
        }
        if (this.isLocalDate()) {
            return this.configValueLocalDate();
        }
        if (this.isLocalDateTime()) {
            return this.configValueLocalDateTime();
        }
        if (this.isMasked()) {
            return this.configLikeValue();
        }
        if (this.isNumberInteger()) {
            return Integer.valueOf(this.value.toString());
        }
        if (this.isNumberLong()) {
            return Long.valueOf(this.value.toString());
        }
        if (this.isNumberDecimals()) {
            return new BigDecimal(this.value.toString());
        }
        if (Number.class.isAssignableFrom(this.classAttribute)) {
            return ReflectionUtils.createInstance(this.classAttribute, this.value.toString());
        }
        if (this.isContainsOrIsNotContains()) {
            return "%" + (this.whereJpa == null || this.whereJpa.isEmpty() ? this.value.toString().toLowerCase() : this.value.toString()) + "%";
        }
        if (this.isStartWith()) {
            return (this.whereJpa == null || this.whereJpa.isEmpty() ? this.value.toString().toLowerCase() : this.value.toString()) + "%";
        }
        if (this.isEndWith()) {
            return "%" + (this.whereJpa == null || this.whereJpa.isEmpty() ? this.value.toString().toLowerCase() : this.value.toString());
        }
        if (this.isEnumerated()) {
            return this.configValueEnum();
        }
        if (this.isBaseEntity()) {
            return this.configValueBaseEntity();
        }
        return this.value;
    }

    private boolean isEndWith() {
        return ConditionSearchType.ENDS_WITH.equals((Object)this.condition);
    }

    private boolean isStartWith() {
        return ConditionSearchType.STARTS_WITH.equals((Object)this.condition);
    }

    private boolean isContainsOrIsNotContains() {
        return ConditionSearchType.CONTAINS.equals((Object)this.condition) || ConditionSearchType.NOT_CONTAINS.equals((Object)this.condition);
    }

    private Object configValueBaseEntity() {
        try {
            Object instanceBaseEntity = this.classAttribute.getConstructor(new Class[0]).newInstance(new Object[0]);
            ((IIdentity)instanceBaseEntity).setId(Long.valueOf(this.value.toString()));
            return instanceBaseEntity;
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return this.value;
        }
    }

    private boolean isBaseEntity() {
        return Long.class.isAssignableFrom(this.value.getClass()) && this.classAttribute != null && this.classAttribute != Void.TYPE && IIdentity.class.isAssignableFrom(this.classAttribute);
    }

    private Object configValueEnum() {
        Class<?> classeEnum = this.classAttribute;
        return Enum.valueOf(classeEnum, this.value.toString());
    }

    private boolean isEnumerated() {
        return this.classAttribute != null && this.classAttribute.isEnum() && this.value.getClass() == String.class;
    }

    private String configLikeValue() {
        String valueFilter = CharacterUtils.onlyNumber((String)this.value);
        if (this.condition.equals((Object)ConditionSearchType.CONTAINS) || this.condition.equals((Object)ConditionSearchType.NOT_CONTAINS)) {
            return "%" + valueFilter + "%";
        }
        if (this.condition.equals((Object)ConditionSearchType.STARTS_WITH)) {
            return valueFilter + "%";
        }
        if (this.condition.equals((Object)ConditionSearchType.ENDS_WITH)) {
            return "%" + valueFilter;
        }
        return valueFilter;
    }

    private boolean isMasked() {
        return this.isCpf() || this.isCnpj() || this.isCpfCnpj() || this.isCnpjBase() || this.isCep();
    }

    private LocalDateTime configValueLocalDateTime() {
        try {
            if (this.value.toString().contains("Z")) {
                Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(this.value.toString());
                return DateUtils.toLocalDateTime(date);
            }
            if (this.value.toString().length() == 19) {
                Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(this.value.toString());
                return DateUtils.toLocalDateTime(date);
            }
            Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").parse(this.value.toString());
            return DateUtils.toLocalDateTime(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return (LocalDateTime)this.value;
        }
    }

    private LocalDate configValueLocalDate() {
        if (String.class.isAssignableFrom(this.value.getClass())) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(this.value.toString());
                return DateUtils.toLocalDate(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return (LocalDate)this.value;
    }

    private Date configValueDate() {
        if (String.class.isAssignableFrom(this.value.getClass())) {
            try {
                this.value = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", GlobalInformation.getInstance().getLocale()).parse(this.value.toString());
                this.value = DateUtils.toDateStartOfDay((Date)this.value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (LocalDate.class.isAssignableFrom(this.value.getClass())) {
            if (this.condition.equals((Object)ConditionSearchType.LESS_EQUAL)) {
                return DateUtils.toDateEndOfDay((LocalDate)this.value);
            }
            if (this.condition.equals((Object)ConditionSearchType.LARGER_EQUAL)) {
                return DateUtils.toDateStartOfDay((LocalDate)this.value);
            }
        } else if (Date.class.isAssignableFrom(this.value.getClass())) {
            if (this.condition.equals((Object)ConditionSearchType.LESS_EQUAL)) {
                return DateUtils.toDateEndOfDay((Date)this.value);
            }
            if (this.condition.equals((Object)ConditionSearchType.LARGER_EQUAL)) {
                return DateUtils.toDateStartOfDay((Date)this.value);
            }
        }
        return (Date)this.value;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCollection() {
        return this.value != null && Collection.class.isAssignableFrom(this.value.getClass());
    }

    public Collection<ConditionSearchType> getConditions() {
        return this.type.getConditionals();
    }

    public String toString() {
        return "ID: " + this.id + " Atributo: " + this.attribute + " Tipo: " + String.valueOf((Object)this.type) + " Descri\u00e7\u00e3o: " + this.description + " Condi\u00e7\u00e3o: " + String.valueOf((Object)this.condition) + " Conteudo: " + String.valueOf(this.value) + " Where JPA: " + this.whereJpa;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isApplyTrunc() {
        return LocalDateTime.class.isAssignableFrom(this.classAttribute) && LocalDate.class.isAssignableFrom(this.value.getClass());
    }

    @XmlTransient
    @JsonIgnore
    public boolean isApplyLower() {
        return this.getCondition().equals((Object)ConditionSearchType.CONTAINS) || this.getCondition().equals((Object)ConditionSearchType.NOT_CONTAINS) || this.getCondition().equals((Object)ConditionSearchType.STARTS_WITH) || this.getCondition().equals((Object)ConditionSearchType.ENDS_WITH);
    }

    public Collection<ConditionSearchType> getConditionals() {
        if (StringUtils.isNullOrEmpty(this.mask)) {
            return this.type.getConditionals();
        }
        return List.of(ConditionSearchType.EQUAL, ConditionSearchType.DIFFERENT);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isHasMask() {
        return !StringUtils.isNullOrEmpty(this.getMask());
    }

    @XmlTransient
    @JsonIgnore
    public boolean isAjustFilterMask() {
        if (this.getCondition() == null) {
            return false;
        }
        boolean equal = this.getCondition().equals((Object)ConditionSearchType.EQUAL);
        boolean different = this.getCondition().equals((Object)ConditionSearchType.DIFFERENT);
        boolean contains = this.getCondition().equals((Object)ConditionSearchType.CONTAINS);
        boolean notContains = this.getCondition().equals((Object)ConditionSearchType.NOT_CONTAINS);
        return !FieldType.ENTITY.equals((Object)this.type) && StringUtils.isNullOrEmpty(this.getWhereJpa()) && this.isHasMask() && (equal || different || contains || notContains);
    }
}

