/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.search;

import br.com.jarch.core.annotation.JArchSearchFieldCheckbox;
import br.com.jarch.core.annotation.JArchSearchTab;
import br.com.jarch.core.crud.search.BaseFieldSearchFactory;
import br.com.jarch.core.crud.search.FieldSearch;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;

final class CheckBoxFieldSearchFactory
extends BaseFieldSearchFactory {
    CheckBoxFieldSearchFactory() {
    }

    void createFieldSearch(Class<?> classEntityOrController, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        this.createFromFields(classEntityOrController, mapFieldSearch);
        this.createFromClass(classEntityOrController, mapFieldSearch);
        this.createFromPackage(classEntityOrController, mapFieldSearch, onlyThisClass);
    }

    private void createFromFields(Class<?> classEntity, Map<String, FieldSearch> mapFieldSearch) {
        ReflectionUtils.getListFields(classEntity, true, true).forEach(field -> {
            Arrays.stream((JArchSearchFieldCheckbox[])field.getAnnotationsByType(JArchSearchFieldCheckbox.class)).forEach(s -> this.addSearchFieldCheckBox(null, classEntity, (JArchSearchFieldCheckbox)s, (Field)field, mapFieldSearch));
            Arrays.stream((JArchSearchTab[])field.getAnnotationsByType(JArchSearchTab.class)).forEach(searchTab -> Arrays.stream(searchTab.searchFieldCheckboxes()).forEach(searchFieldCheckbox -> this.addSearchFieldCheckBox((JArchSearchTab)searchTab, classEntity, (JArchSearchFieldCheckbox)searchFieldCheckbox, (Field)field, mapFieldSearch)));
        });
    }

    private void createFromClass(Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        this.createFromClass(null, (JArchSearchFieldCheckbox[])classActionEntity.getAnnotationsByType(JArchSearchFieldCheckbox.class), classActionEntity, mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classActionEntity.getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromClass(searchTab, searchTab.searchFieldCheckboxes(), searchTab.classEntity(), mapFieldSearch);
        }
    }

    private void createFromClass(JArchSearchTab searchTab, JArchSearchFieldCheckbox[] searchFields, Class<?> classActionEntity, Map<String, FieldSearch> mapFieldSearch) {
        for (JArchSearchFieldCheckbox searchField : searchFields) {
            Class<?> classEntity = this.getClassEntityFrom(classActionEntity);
            String fieldName = searchField.field();
            Field field = searchField.classEntity() != Void.TYPE ? ReflectionUtils.getField(searchField.classEntity(), fieldName, false) : ReflectionUtils.getField(classEntity, fieldName, false);
            this.addSearchFieldCheckBox(searchTab, classActionEntity, searchField, field, mapFieldSearch);
        }
    }

    private void createFromPackage(Class<?> classControllerOrEntity, Map<String, FieldSearch> mapFieldSearch, boolean onlyThisClass) {
        Class<?> classEntity = this.getClassEntityFrom(classControllerOrEntity);
        this.createFromSearchTab(null, classEntity, (JArchSearchFieldCheckbox[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchFieldCheckbox.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classControllerOrEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromSearchTab(searchTab, classEntity, searchTab.searchFieldCheckboxes(), mapFieldSearch);
        }
        if (onlyThisClass || classEntity.equals(classControllerOrEntity) || classEntity.getPackage().equals(classControllerOrEntity.getPackage())) {
            return;
        }
        this.createFromSearchTab(null, classEntity, (JArchSearchFieldCheckbox[])classEntity.getPackage().getAnnotationsByType(JArchSearchFieldCheckbox.class), mapFieldSearch);
        for (JArchSearchTab searchTab : (JArchSearchTab[])classEntity.getPackage().getAnnotationsByType(JArchSearchTab.class)) {
            this.createFromSearchTab(searchTab, classEntity, searchTab.searchFieldCheckboxes(), mapFieldSearch);
        }
    }

    private void createFromSearchTab(JArchSearchTab searchTab, Class<?> classEntity, JArchSearchFieldCheckbox[] searchFields, Map<String, FieldSearch> mapFieldSearch) {
        for (JArchSearchFieldCheckbox searchField : searchFields) {
            if (searchField.classEntity() != Void.TYPE && searchField.classEntity() != classEntity || searchTab != null && searchTab.classEntity() != classEntity) continue;
            String fieldName = searchField.field();
            Field field = searchField.classEntity() != Void.TYPE ? ReflectionUtils.getField(searchField.classEntity(), fieldName, true) : ReflectionUtils.getField(classEntity, fieldName, true);
            this.addSearchFieldCheckBox(searchTab, classEntity, searchField, field, mapFieldSearch);
        }
    }

    private void addSearchFieldCheckBox(JArchSearchTab searchTab, Class<?> classEntity, JArchSearchFieldCheckbox searchField, Field field, Map<String, FieldSearch> mapFieldSearch) {
        try {
            if (Boolean.FALSE.equals(searchField.enable().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get())) {
                return;
            }
        }
        catch (Exception e) {
            LogUtils.generate(e);
        }
        classEntity = searchTab != null && searchTab.classEntity() != Void.TYPE ? searchTab.classEntity() : classEntity;
        String fieldName = searchField.field();
        String atributo = fieldName.isEmpty() && field != null ? field.getName() : fieldName;
        String descricao = searchField.label() == null || searchField.label().isEmpty() ? "label.".concat(atributo) : searchField.label();
        descricao = BundleUtils.messageBundle(descricao);
        String id = this.createId(classEntity, searchField.id(), atributo, mapFieldSearch);
        FieldSearch fieldSearch = FieldSearch.createInstance().annotation(JArchSearchFieldCheckbox.class).classAttribute(Boolean.class).type(FieldType.BOOLEAN).id(id).attribute(fieldName).description(descricao).condition(ConditionSearchType.EQUAL).where(searchField.whereJpa()).row(searchField.row()).column(searchField.column()).span(searchField.span()).tabName(searchTab == null ? "label.main" : searchTab.name()).tabOrder(searchTab == null ? 0 : searchTab.order());
        if (searchField.hide()) {
            fieldSearch.hide();
            fieldSearch.clearValueByButton(false);
        }
        mapFieldSearch.put(id, fieldSearch);
    }
}

