/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.parameter;

import br.com.jarch.core.crud.parameter.BaseParameterService;
import br.com.jarch.core.crud.parameter.IParameter;
import br.com.jarch.core.model.IUser;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.util.LogUtils;
import java.lang.annotation.Annotation;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.inject.spi.CDI;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ParameterEjb {
    @Resource(lookup="java:comp/DefaultManagedExecutorService")
    private ManagedExecutorService executor;

    public static ParameterEjb getInstance() {
        return (ParameterEjb)CDI.current().select(ParameterEjb.class, new Annotation[0]).get();
    }

    public Future<IParameter<?>> save(Long idMultitenant, IUser user, BaseParameterService<?, ?> service, IParameter<?> parameter) {
        return this.executor.submit(() -> {
            try {
                LogUtils.start();
                MultiTenant.getInstance().set(idMultitenant);
                UserInformation.getInstance().set(user);
                service.save(parameter);
                parameter.setErroSave(null);
                IParameter iParameter = parameter;
                return iParameter;
            }
            catch (Exception e) {
                parameter.setErroSave(e.getMessage());
                IParameter iParameter = parameter;
                return iParameter;
            }
            finally {
                LogUtils.end();
            }
        });
    }
}

