/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.parameter;

import br.com.jarch.core.crud.parameter.BaseParameterService;
import br.com.jarch.core.crud.parameter.IParameter;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public abstract class Parameter<T, S extends BaseParameterService<?, ?>>
implements IParameter<T> {
    @Inject
    private S service;
    private Long id;
    private BigInteger valueInteger;
    private BigDecimal valueDecimal;
    private LocalDateTime valueDateTime;
    private String valueString;
    private String valueMemo;
    private byte[] valueBinary;
    private String valueOtherInformation;
    private String description;
    private String explanation;
    private String menu;
    private String tab;
    private String fieldSet;
    private String erroSave;

    @PostConstruct
    private void init() {
        this.loadData();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String key() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public void valid() {
    }

    @Override
    public BigInteger getValueInteger() {
        return this.valueInteger;
    }

    @Override
    public void setValueInteger(BigInteger valueInteger) {
        this.valueInteger = valueInteger;
    }

    @Override
    public BigDecimal getValueDecimal() {
        return this.valueDecimal;
    }

    @Override
    public void setValueDecimal(BigDecimal valueDecimal) {
        this.valueDecimal = valueDecimal;
    }

    @Override
    public LocalDateTime getValueDateTime() {
        return this.valueDateTime;
    }

    @Override
    public void setValueDateTime(LocalDateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    @Override
    public String getValueString() {
        return this.valueString;
    }

    @Override
    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    @Override
    public String getValueMemo() {
        return this.valueMemo;
    }

    @Override
    public void setValueMemo(String valueMemo) {
        this.valueMemo = valueMemo;
    }

    @Override
    public byte[] getValueBinary() {
        return this.valueBinary;
    }

    @Override
    public void setValueBinary(byte[] valueBinary) {
        this.valueBinary = valueBinary;
    }

    @Override
    public String getValueOtherInformation() {
        return this.valueOtherInformation;
    }

    @Override
    public void setValueOtherInformation(String valueOtherInformation) {
        this.valueOtherInformation = valueOtherInformation;
    }

    @Override
    public Collection<?> getList() {
        return Collections.emptyList();
    }

    @Override
    public boolean isDate() {
        return FieldType.DATE.equals((Object)this.getType()) && !LocalDate.class.isAssignableFrom(ReflectionUtils.getGenericClass(this.getClass(), 0));
    }

    @Override
    public boolean isDateTime() {
        return FieldType.DATE_TIME.equals((Object)this.getType()) && !LocalDateTime.class.isAssignableFrom(ReflectionUtils.getGenericClass(this.getClass(), 0));
    }

    @Override
    public boolean isLocalDate() {
        return FieldType.DATE.equals((Object)this.getType()) && LocalDate.class.isAssignableFrom(ReflectionUtils.getGenericClass(this.getClass(), 0));
    }

    @Override
    public boolean isLocalDateTime() {
        return FieldType.DATE_TIME.equals((Object)this.getType()) && LocalDateTime.class.isAssignableFrom(ReflectionUtils.getGenericClass(this.getClass(), 0));
    }

    @Override
    public boolean isChips() {
        return FieldType.CHIPS.equals((Object)this.getType());
    }

    @Override
    public String getMask() {
        return IParameter.super.getMask();
    }

    @Override
    public boolean isCep() {
        return FieldType.CEP.equals((Object)this.getType());
    }

    @Override
    public boolean isCnpj() {
        return FieldType.CNPJ.equals((Object)this.getType());
    }

    @Override
    public boolean isCnpjBase() {
        return FieldType.CNPJ_BASE.equals((Object)this.getType());
    }

    @Override
    public boolean isCpfCnpj() {
        return FieldType.CPFCNPJ.equals((Object)this.getType());
    }

    @Override
    public boolean isCode() {
        return FieldType.CODE.equals((Object)this.getType());
    }

    @Override
    public boolean isMonthYear() {
        return FieldType.MONTH_YEAR.equals((Object)this.getType());
    }

    @Override
    public boolean isCpf() {
        return FieldType.CPF.equals((Object)this.getType());
    }

    @Override
    public boolean isDescriptionNameGeneric() {
        return IParameter.super.isDescriptionNameGeneric();
    }

    @Override
    public boolean isDescriptionNameGenericSmall() {
        return IParameter.super.isDescriptionNameGenericSmall();
    }

    @Override
    public boolean isPassword() {
        return FieldType.PASSWORD.equals((Object)this.getType());
    }

    @Override
    public boolean isEmail() {
        return FieldType.EMAIL.equals((Object)this.getType());
    }

    @Override
    public boolean isHour() {
        return FieldType.HOUR.equals((Object)this.getType());
    }

    @Override
    public boolean isIm() {
        return FieldType.IM.equals((Object)this.getType());
    }

    @Override
    public boolean isMemoRich() {
        return FieldType.MEMO_RICH.equals((Object)this.getType());
    }

    @Override
    public boolean isMemoSimple() {
        return FieldType.MEMO_SIMPLE.equals((Object)this.getType());
    }

    @Override
    public boolean isM2() {
        return FieldType.M2.equals((Object)this.getType());
    }

    @Override
    public boolean isNumber() {
        return FieldType.NUMBER.equals((Object)this.getType()) || FieldType.QUANTITY.equals((Object)this.getType());
    }

    @Override
    public boolean isMoney() {
        return FieldType.MONEY.equals((Object)this.getType());
    }

    @Override
    public boolean isPercentage() {
        return FieldType.PERCENTAGE.equals((Object)this.getType());
    }

    @Override
    public boolean isRate() {
        return FieldType.RATE.equals((Object)this.getType());
    }

    @Override
    public boolean isShortDescription() {
        return FieldType.SHORT_DESCRIPTION.equals((Object)this.getType());
    }

    @Override
    public boolean isDecimals() {
        return IParameter.super.isDecimals();
    }

    @Override
    public boolean isRg() {
        return FieldType.RG.equals((Object)this.getType());
    }

    @Override
    public boolean isTelephone() {
        return IParameter.super.isTelephone();
    }

    @Override
    public boolean isBoolean() {
        return FieldType.BOOLEAN.equals((Object)this.getType());
    }

    @Override
    public boolean isEntity() {
        return FieldType.ENTITY.equals((Object)this.getType());
    }

    @Override
    public boolean isBinary() {
        return FieldType.BINARY.equals((Object)this.getType());
    }

    @Override
    public boolean isEnumerated() {
        return FieldType.ENUMERATED.equals((Object)this.getType());
    }

    @Override
    public boolean isCollection() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        try {
            if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                return Collection.class.isAssignableFrom((Class)parameterizedType.getRawType());
            }
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
        return false;
    }

    @Override
    public boolean isString() {
        return IParameter.super.isString();
    }

    @Override
    public boolean isCurrency() {
        return IParameter.super.isCurrency();
    }

    @Override
    public boolean isTime() {
        return IParameter.super.isTime();
    }

    @Override
    public boolean isArray() {
        try {
            Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            return !type.toString().contains("Collection") && !type.toString().contains("List") && !type.toString().contains("Set") && ((Class)type).isArray();
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            return false;
        }
    }

    @Override
    public void save() {
        ((BaseParameterService)this.service).save(this);
        this.loadData();
    }

    @Override
    public void reload() {
        this.loadData();
    }

    private void loadData() {
        if (this.service != null) {
            ((BaseParameterService)this.service).configBeanFromEntity(this);
        }
    }

    @Override
    public String labelLegend() {
        return "";
    }

    @Override
    public String valueLegend() {
        return "";
    }

    @Override
    public String getDescription() {
        String result;
        String string = result = this.description == null ? this.description() : this.description;
        if (result == null) {
            return "";
        }
        if (result.startsWith("???") && result.endsWith("???")) {
            return BundleUtils.messageBundle(result.replace("???", ""));
        }
        return result;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getExplanation() {
        return this.explanation == null ? this.explanation() : this.explanation;
    }

    @Override
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    @Override
    public String getMenu() {
        return this.menu;
    }

    @Override
    public void setMenu(String menu) {
        this.menu = menu;
    }

    @Override
    public String getTab() {
        return this.tab;
    }

    @Override
    public void setTab(String tab) {
        this.tab = tab;
    }

    @Override
    public String getFieldSet() {
        return this.fieldSet;
    }

    @Override
    public void setFieldSet(String fieldSet) {
        this.fieldSet = fieldSet;
    }

    @Override
    public String getErroSave() {
        return this.erroSave;
    }

    @Override
    public void setErroSave(String erroSave) {
        this.erroSave = erroSave;
    }

    @Override
    public int getColspanLabel() {
        return IParameter.super.getColspanLabel();
    }

    @Override
    public int getColspanValue() {
        return IParameter.super.getColspanValue();
    }
}

