/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.listener;

import br.com.jarch.core.annotation.JArchValidExclusive;
import br.com.jarch.core.annotation.JArchValidExclusives;
import br.com.jarch.core.exception.ExclusiveException;
import br.com.jarch.core.jpa.api.ClientJpqlBuilder;
import br.com.jarch.core.jpa.api.OperatorJpql;
import br.com.jarch.core.jpa.api.RootJpql;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.LockModeType;
import javax.transaction.Transactional;

@ApplicationScoped
public class VerifyExclusive {
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public <E extends ICrudEntity> void verify(E entityOrigin) {
        if (entityOrigin.isIgnoreExclusive()) {
            return;
        }
        this.verifyFields(entityOrigin);
        this.verifyClass(entityOrigin);
    }

    private <E extends ICrudEntity> void verifyFields(E entityOrigin) {
        ReflectionUtils.getListFields(entityOrigin, true, true).stream().filter(f -> f.isAnnotationPresent(JArchValidExclusive.class)).filter(f -> this.enable(f.getAnnotation(JArchValidExclusive.class).enable(), entityOrigin)).filter(f -> !f.getAnnotation(JArchValidExclusive.class).ignoreNull() || ReflectionUtils.getValueByField(entityOrigin, f) != null).filter(f -> !this.getRootJpql(entityOrigin).where().equalsTo(f.getName(), ReflectionUtils.getValueByField(entityOrigin, f)).and(entityOrigin.getId() != null).notEqualsTo(entityOrigin.getId() != null, "id", entityOrigin.getId()).collect().list().isEmpty()).findAny().ifPresent(f -> VerifyExclusive.messageErroExclusive(entityOrigin, f));
    }

    private void verifyClass(ICrudEntity entity) {
        JArchValidExclusives[] exclusivess;
        for (JArchValidExclusives exclusives : exclusivess = (JArchValidExclusives[])entity.getClass().getAnnotationsByType(JArchValidExclusives.class)) {
            if (!this.enable(exclusives.enable(), entity) || this.ignoreNull(exclusives, entity)) continue;
            OperatorJpql<? extends ICrudEntity> operatorJpql = this.configuraFiltroId(entity);
            if ((operatorJpql = this.configureFilters(entity, exclusives, operatorJpql)) == null || operatorJpql.collect().list().isEmpty()) continue;
            VerifyExclusive.messageErroExclusives(entity, exclusives);
        }
    }

    private boolean ignoreNull(JArchValidExclusives exclusives, ICrudEntity entity) {
        return exclusives.ignoreNull() && Arrays.stream(exclusives.fields()).anyMatch(f -> ReflectionUtils.getValueByName(entity, f) == null);
    }

    private OperatorJpql<? extends ICrudEntity> configureFilters(ICrudEntity entity, JArchValidExclusives exclusives, OperatorJpql<? extends ICrudEntity> operatorJpql) {
        String[] fields;
        for (String field : fields = exclusives.fields()) {
            Object object = ReflectionUtils.getValueByName(entity, field);
            if (object == null) continue;
            if (operatorJpql == null) {
                if (ICrudEntity.class.isAssignableFrom(object.getClass()) && ((ICrudEntity)object).getId() == null) continue;
                operatorJpql = this.getRootJpql(entity).where().equalsTo(field, object);
                continue;
            }
            operatorJpql = operatorJpql.and().equalsTo(field, object);
        }
        return operatorJpql;
    }

    private OperatorJpql<? extends ICrudEntity> configuraFiltroId(ICrudEntity entity) {
        if (entity.getId() != null) {
            return this.getRootJpql(entity).where().notEqualsTo("id", entity.getId());
        }
        return null;
    }

    private static void messageErroExclusives(ICrudEntity crudEntity, JArchValidExclusives annotation) {
        if (!"message.validExclusives".equals(annotation.message())) {
            throw new ExclusiveException(BundleUtils.messageBundle(annotation.message()));
        }
        String fields = Arrays.stream(annotation.fields()).map(s -> BundleUtils.messageBundle("label.".concat((String)s))).collect(Collectors.joining(", "));
        String messageExclusives = BundleUtils.messageBundleParam("message.validExclusives", fields);
        LogUtils.generate("Entity: " + crudEntity.getClass().getName() + " Fields: " + Arrays.stream(annotation.fields()).collect(Collectors.joining(", ")));
        throw new ExclusiveException(messageExclusives);
    }

    private static void messageErroExclusive(ICrudEntity crudEntity, Field fieldAtributo) {
        JArchValidExclusive annotation = fieldAtributo.getAnnotation(JArchValidExclusive.class);
        if (!annotation.message().equals("message.validExclusive")) {
            throw new ExclusiveException(BundleUtils.messageBundle(annotation.message()));
        }
        Object labelField = "label." + fieldAtributo.getName();
        if (annotation.label() != null && !annotation.label().isEmpty()) {
            labelField = annotation.label();
        }
        String messageExclusive = BundleUtils.messageBundleParam("message.validExclusive", new String[]{labelField});
        LogUtils.generate("Entity: " + crudEntity.getClass().getName() + " Field: " + fieldAtributo.getName());
        throw new ExclusiveException(messageExclusive);
    }

    private RootJpql<? extends ICrudEntity> getRootJpql(ICrudEntity entity) {
        return ClientJpqlBuilder.newInstance(entity.getClass()).lockMode(LockModeType.PESSIMISTIC_WRITE);
    }

    private boolean enable(Class<? extends Predicate> predicateClass, Object entity) {
        if (!predicateClass.isInterface()) {
            try {
                Predicate predicate = predicateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return predicate.test(entity);
            }
            catch (Exception ex) {
                LogUtils.generate(ex);
            }
        }
        return true;
    }
}

