/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.communication;

import br.com.jarch.core.annotation.JArchService;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.crud.communication.Alerts;
import br.com.jarch.core.crud.communication.Attach;
import br.com.jarch.core.crud.communication.CommunicationAttachEntity;
import br.com.jarch.core.crud.communication.CommunicationEntity;
import br.com.jarch.core.crud.communication.CommunicationRepository;
import br.com.jarch.core.crud.communication.ICommunication;
import br.com.jarch.core.crud.communication.Message;
import br.com.jarch.core.crud.communication.Messages;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.transaction.Transactional;

@JArchService
public class CommunicationService
extends CrudService<CommunicationEntity, CommunicationRepository> {
    protected static final String JARCH_COMMUNICATION_LAST_SEARCH = "JARCH.COMMUNICATION.LAST_SEARCH";
    protected static final String JARCH_COMMUNICATION_ALERTS = "JARCH.COMMUNICATION.ALERTS";
    protected static final String JARCH_COMMUNICATION_MESSAGES = "JARCH.COMMUNICATION.MESSAGES";
    protected static final int MINUTES_INTERVAL_SEARCH = 5;
    @Inject
    private Instance<Alerts> instanceAlert;
    @Inject
    private Instance<Messages> instanceMessage;

    public static CommunicationService getInstance() {
        return (CommunicationService)CDI.current().select(CommunicationService.class, new Annotation[0]).get();
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public CommunicationEntity insertNewTransaction(CommunicationEntity communicationEntity) {
        this.insert(communicationEntity);
        return communicationEntity;
    }

    public CommunicationEntity insert(ICommunication communication) {
        CommunicationEntity result = new CommunicationEntity(communication);
        this.insert(result);
        return result;
    }

    public void saveDataReading(CommunicationEntity entity) {
        entity.setReading(LocalDateTime.now());
        this.change(entity);
    }

    public void archived(CommunicationEntity entity) {
        CommunicationEntity communicationEntity = (CommunicationEntity)((CommunicationRepository)this.getRepository()).find(entity.getId());
        communicationEntity.setFiled(true);
        this.change(communicationEntity);
    }

    public void removeAllExpiration() {
        Set<Long> idsExpiration = ((CommunicationRepository)this.getRepository()).searchAllExpiration();
        for (Long id : idsExpiration) {
            LogUtils.generate("Removing Expired Expiration: " + id);
            ((CommunicationRepository)this.getRepository()).delete(id);
        }
    }

    public boolean isTimeOutSearch() {
        LocalDateTime now;
        LocalDateTime timeLastSearch = GlobalInformation.getInstance().get(JARCH_COMMUNICATION_LAST_SEARCH, LocalDateTime.now().minusMinutes(5L));
        return Math.abs(ChronoUnit.MINUTES.between(timeLastSearch, now = LocalDateTime.now())) >= 5L;
    }

    public Alerts getAlertsContext() {
        if (this.instanceAlert.isUnsatisfied() || this.instanceAlert.isAmbiguous() || !this.instanceAlert.isResolvable() || UserInformation.getInstance().isNotExists()) {
            return new Alerts();
        }
        if (this.isTimeOutSearch()) {
            GlobalInformation.getInstance().set(JARCH_COMMUNICATION_ALERTS, (Serializable)this.instanceAlert.get());
            GlobalInformation.getInstance().set(JARCH_COMMUNICATION_LAST_SEARCH, LocalDateTime.now());
        }
        return GlobalInformation.getInstance().get(JARCH_COMMUNICATION_ALERTS, new Alerts());
    }

    public Messages getMensagensContext() {
        if (this.instanceMessage.isUnsatisfied() || this.instanceMessage.isAmbiguous() || !this.instanceMessage.isResolvable() || UserInformation.getInstance().isNotExists()) {
            return new Messages();
        }
        if (this.isTimeOutSearch()) {
            GlobalInformation.getInstance().set(JARCH_COMMUNICATION_MESSAGES, (Serializable)this.instanceMessage.get());
            GlobalInformation.getInstance().set(JARCH_COMMUNICATION_LAST_SEARCH, LocalDateTime.now());
        }
        return GlobalInformation.getInstance().get(JARCH_COMMUNICATION_MESSAGES, new Messages());
    }

    public void setTimeOutSearch() {
        GlobalInformation.getInstance().set(JARCH_COMMUNICATION_LAST_SEARCH, DateUtils.toLocalDateTimeStartOfDay(LocalDate.now()));
    }

    public void attach(CommunicationEntity communication, String fileName, File file) {
        try {
            LogUtils.start();
            CommunicationAttachEntity communicationAttach = ((CommunicationRepository)this.getRepository()).newAttach(communication);
            ((CommunicationRepository)this.getRepository()).saveAttachFromFile(communicationAttach, fileName, file);
            LogUtils.end();
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
    }

    public void attach(CommunicationEntity communication, String fileName, byte[] bytes) {
        try {
            LogUtils.start();
            CommunicationAttachEntity communicationAttach = ((CommunicationRepository)this.getRepository()).newAttach(communication);
            ((CommunicationRepository)this.getRepository()).saveAttachFromBytes(communicationAttach, fileName, bytes);
            LogUtils.end();
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
    }

    public void send(Message message) {
        CommunicationEntity communication = new CommunicationEntity(message);
        communication.setFiled(true);
        ((CommunicationRepository)this.getRepository()).insert(communication);
        for (Attach attach : message.getAttachs()) {
            if (attach.getFile() != null) {
                this.attach(communication, attach.getFileName(), attach.getFile());
                continue;
            }
            this.attach(communication, attach.getFileName(), attach.getBinary());
        }
        communication = (CommunicationEntity)((CommunicationRepository)this.getRepository()).find(communication.getId());
        communication.setFiled(false);
        ((CommunicationRepository)this.getRepository()).change(communication);
    }
}

