/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.batch;

import br.com.jarch.core.annotation.JArchOrderBy;
import br.com.jarch.core.annotation.JArchOrderByField;
import br.com.jarch.core.annotation.JArchSearchWhereJpa;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.batch.ExecutionEntity;
import br.com.jarch.core.crud.entity.CrudMultiTenantEntity;
import br.com.jarch.core.jpa.converter.LocalDateTimeJpaConverter;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Filter;
import org.hibernate.envers.Audited;

@Audited
@Table(name="tb_batch_execution_log", indexes={@Index(columnList="dh_time", name="dx_batchexecutionlogdhtim"), @Index(columnList="ds_information", name="dx_batchexecutionlogdsinf")})
@Entity(name="log")
@SequenceGenerator(name="LogIdSequence", sequenceName="sq_idbatchexecutionlog", allocationSize=1)
@JArchOrderBy(fields={@JArchOrderByField(value="id", desc=true)})
@JArchSearchWhereJpa(id="filterLastExecutionByCode", conditionWhereJpa="log.execution.id = :idExecution", active=false)
public class LogEntity
extends CrudMultiTenantEntity {
    public static final String FILTER_LAST_EXECUTION_BY_CODE = "filterLastExecutionByCode";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="LogIdSequence")
    @Column(name="id_batchexecutionlog")
    private Long id;
    @ManyToOne
    @JoinColumn(name="id_batchexecution", nullable=false)
    @Filter(name="tenant")
    private ExecutionEntity execution;
    @Column(name="dh_time", nullable=false)
    @Convert(converter=LocalDateTimeJpaConverter.class)
    @JArchValidRequired(value="label.timeLog")
    private LocalDateTime timeLog;
    @Column(name="ds_information", nullable=false, length=500)
    @JArchValidRequired(value="label.information")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String information;

    public LogEntity() {
    }

    public LogEntity(Long id, LocalDateTime timeLog, String information) {
        this.id = id;
        this.timeLog = timeLog;
        this.information = information;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public ExecutionEntity getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    public LocalDateTime getTimeLog() {
        return this.timeLog;
    }

    public void setTimeLog(LocalDateTime timeLog) {
        this.timeLog = timeLog;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
    }
}

