/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.cdi;

import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.model.User;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.CDI;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Named
@ApplicationScoped
public class GlobalInformation
implements Serializable {
    private final Map<String, Map<String, Serializable>> map = new ConcurrentHashMap<String, Map<String, Serializable>>();

    public static GlobalInformation getInstance() {
        return (GlobalInformation)CDI.current().select(GlobalInformation.class, new Annotation[0]).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Serializable value) {
        try {
            GlobalInformation.getSession(false).setAttribute(this.getKeySession(key), (Object)value);
        }
        catch (Exception ex) {
            try {
                Map<String, Map<String, Serializable>> map = this.map;
                synchronized (map) {
                    this.map.computeIfAbsent(Thread.currentThread().getName(), k -> new ConcurrentHashMap());
                    this.map.get(Thread.currentThread().getName()).put(key, value);
                }
            }
            catch (Exception ex2) {
                LogUtils.generate(ex2);
                throw new RuntimeException(ex2);
            }
        }
    }

    public <T extends Serializable> T get(String key) {
        return this.getT(key);
    }

    private <T extends Serializable> T getT(String key) {
        try {
            return (T)((Serializable)GlobalInformation.getSession(false).getAttribute(this.getKeySession(key)));
        }
        catch (Exception ex) {
            Map<String, Serializable> map2 = this.map.get(Thread.currentThread().getName());
            if (map2 == null) {
                return null;
            }
            return (T)map2.get(key);
        }
    }

    public <T extends Serializable> T get(String key, T valueDefault) {
        T result = this.getT(key);
        if (result == null) {
            return valueDefault;
        }
        return result;
    }

    public boolean exists(String key) {
        try {
            return !GlobalInformation.getSession(false).isNew() && GlobalInformation.getSession(false).getAttribute(this.getKeySession(key)) != null;
        }
        catch (Exception ex) {
            Map<String, Serializable> map2 = this.map.get(Thread.currentThread().getName());
            if (map2 == null) {
                return false;
            }
            return map2.get(key) != null;
        }
    }

    public void remove(String key) {
        try {
            GlobalInformation.getSession(false).removeAttribute(this.getKeySession(key));
        }
        catch (Exception ex) {
            this.map.get(Thread.currentThread().getName()).remove(key);
        }
    }

    public boolean isSession() {
        try {
            GlobalInformation.getSession(false).getId();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void clear() {
        if (this.isSession()) {
            GlobalInformation.getSession(false).invalidate();
        } else {
            String keyRemove = Thread.currentThread().getName();
            Map<String, Serializable> map2 = this.map.get(keyRemove);
            if (map2 == null) {
                return;
            }
            for (String key : map2.keySet()) {
                map2.remove(key);
            }
            this.map.remove(keyRemove);
        }
    }

    private String getKeySession(String key) {
        String name = Thread.currentThread().getContextClassLoader().getName();
        return name.concat("_").concat(key);
    }

    private static HttpSession getSession(boolean create) {
        return GlobalInformation.getRequest().getSession(create);
    }

    private static HttpServletRequest getRequest() {
        return (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    public void setLocale(Locale locale) {
        this.set("JARCH.CONFIG.LOCALE_LANGUAGE", (Serializable)((Object)locale.getLanguage()));
        this.set("JARCH.CONFIG.LOCALE_COUNTRY", (Serializable)((Object)locale.getCountry()));
        this.set("JARCH.CONFIG.LOCALE_VARIANT", (Serializable)((Object)StringUtils.nullAsBlank(locale.getVariant())));
    }

    public Locale getLocale() {
        String language = this.get("JARCH.CONFIG.LOCALE_LANGUAGE", "pt");
        String country = this.get("JARCH.CONFIG.LOCALE_COUNTRY", "BR");
        String variant = (String)((Object)this.get("JARCH.CONFIG.LOCALE_VARIANT", String.valueOf(MultiTenant.getInstance().exists() ? Long.valueOf(MultiTenant.getInstance().get()) : "")));
        return new Locale(language, country, variant);
    }

    public void moveAllToNewKey(String oldKey, String newKey) {
        Map<String, Serializable> mapsActual = this.map.get(oldKey);
        if (mapsActual == null) {
            return;
        }
        for (Map.Entry<String, Serializable> entry : mapsActual.entrySet()) {
            this.map.computeIfAbsent(newKey, k -> new ConcurrentHashMap());
            this.map.get(newKey).put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Serializable> entry : mapsActual.entrySet()) {
            mapsActual.remove(entry.getKey());
        }
        this.map.remove(oldKey);
    }

    public void startContext(Long idMultiTenant, Long idUser) {
        MultiTenant.getInstance().set(idMultiTenant);
        UserInformation.getInstance().set(new User(idUser));
    }

    public void endContext() {
        this.clear();
    }

    public String getTitle() {
        return this.get("JARCH.APP.TITLE", BundleUtils.messageBundle("label.siglaSistema"));
    }

    public void configLocale(long multiTenantId) {
        Locale locale = GlobalInformation.getInstance().getLocale();
        locale = locale == null ? new Locale("pt", "BR", "" + multiTenantId) : new Locale(locale.getLanguage(), locale.getCountry(), "" + multiTenantId);
        this.setLocale(locale);
    }
}

