/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.annotation.constraint;

import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.util.BeanValidationUtils;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.CollectionUtils;
import br.com.jarch.util.StringUtils;
import java.util.Collection;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class RequiredConstraint
implements ConstraintValidator<JArchValidRequired, Object> {
    private JArchValidRequired annotation;

    public void initialize(JArchValidRequired value) {
        this.annotation = value;
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        String messageFinal = this.getMessageConstraint();
        constraintValidatorContext.disableDefaultConstraintViolation();
        constraintValidatorContext.buildConstraintViolationWithTemplate(messageFinal).addConstraintViolation();
        if (Objects.isNull(value)) {
            return false;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return StringUtils.isNotEmpty(value.toString());
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            return CollectionUtils.isNotEmpty((Collection)value);
        }
        return true;
    }

    private String getMessageConstraint() {
        String mensagem;
        String string = mensagem = this.annotation.message().isEmpty() ? "{message.required}" : this.annotation.message();
        if (!mensagem.contains("message.required")) {
            return mensagem;
        }
        String result = BeanValidationUtils.messageBundle(mensagem);
        result = result.replace("{0}", BundleUtils.messageBundle(this.annotation.value()));
        result = result.replace("??????:", "");
        return result;
    }
}

